# Cardiomyocyte maturation: advances in knowledge and implications for regenerative medicine

Elaheh Karbassi1,2,3, Aidan Fenix1,2,3, Silvia Marchiano1,2,3, Naoto Muraoka1,2,3, Kenta Nakamura1,2,4, Xiulan Yang1,2,3, Charles E. Murry1,2,3,4,5,\*

1Institute for Stem Cell and Regenerative Medicine, University of Washington, Seattle, WA, USA.   
2Center for Cardiovascular Biology, University of Washington, Seattle, WA, USA.   
3Department of Pathology, University of Washington, Seattle, WA, USA.   
4Division of Cardiology, Department of Medicine, University of Washington, Seattle, WA, USA.   
5Department of Bioengineering, University of Washington, Seattle, WA, USA.

# Abstract

Our knowledge of pluripotent stem cell (PSC) biology has advanced to the point where we now can generate most cells of the human body in the laboratory. PSC-derived cardiomyocytes can be generated routinely with high yield and purity for disease research and drug development, and these cells are now gradually entering the clinical research phase for the testing of heart regeneration therapies. However, a major hurdle for their applications is the immature state of these cardiomyocytes. In this Review, we describe the structural and functional properties of cardiomyocytes and present the current approaches to mature PSC-derived cardiomyocytes. To date, the greatest success in maturation of PSC-derived cardiomyocytes has been with transplantation into the heart in animal models and the engineering of 3D heart tissues with electromechanical conditioning. In conventional 2D cell culture, biophysical stimuli such as mechanical loading, electrical stimulation and nanotopology cues all induce substantial maturation, particularly of the contractile cytoskeleton. Metabolism has emerged as a potent means to control maturation with unexpected effects on electrical and mechanical function. Different interventions induce distinct facets of maturation, suggesting that activating multiple signalling networks might lead to increased maturation. Despite considerable progress, we are still far from being able to generate PSC-derived cardiomyocytes with adult-like phenotypes in vitro. Future progress will come from identifying the developmental drivers of maturation and leveraging them to create more mature cardiomyocytes for research and regenerative medicine.

Remarkable progress has been made over the past decade in our ability to control the differentiation of human pluripotent stem cells (hPSCs). Lessons learned from studies on embryonic development have enabled hPSC differentiation to be directed into the ectoderm, endoderm and mesoderm lineages, and our knowledge of the distal branches of these germ layers is growing. With the use of hPSCs we have learned about human development, how to build tissues and how genetic variants cause disease. Hopes are high that soon we will be able to discover new drugs with the use of hPSCs and, perhaps one day, use these cells in cell-replacement therapies.

Building on these achievements, the next challenge is to understand and control cell maturation. Most protocols generate cells at embryonic stages or early fetal stages, typically stages just after organogenesis completion. Therefore, the generated cells lack many attributes of adult cells that are desirable for drug screening, modelling of adult-onset diseases or replacing cells lost to disease. For example, hPSC-derived liver cells might not produce albumin or might lack the enzymatic capacity to metabolize urea or drugs. hPSCderived $\beta$ -cells might not secrete insulin in response to a glucose challenge, whereas hPSCderived neurons might lack spontaneous firing, and late-differentiating neural cells, such as oligodendrocytes, are still difficult to obtain.

These limitations are relevant for heart research and therapy development. Cardiac drug development has slowed over the past 20 years, creating a large unmet need. Many cardiac genetic diseases have middle-age onset and are difficult to model with hPSC-derived cardiomyocytes (hPSC-CMs). For cell-replacement therapies, the electrical immaturity of hPSC-CMs might underlie the ventricular arrhythmias that accompany cell engraftment in animal models1. Moreover, unlike studies of cell-lineage determination, we cannot rely on lessons from developmental biology to guide the maturation of hPSC-CMs (Box 1). Our knowledge of cardiac development at late gestation is limited2,3 and stems principally from studies in animal models. Although a few pioneering studies on human late prenatal or early postnatal heart growth have been performed4–6, much of what we know about human heart maturation is formed on the basis of findings in vitro and in adult hearts. Therefore, our mechanistic understanding of cardiomyocyte maturation is not as advanced as that of embryonic development.

Postnatal developmental changes in cardiomyocytes are remarkable. The cells withdraw from the cell cycle, typically undergoing one more round of DNA synthesis without cell division, generating large, tetraploid nuclei (in humans) or binucleated myocytes (in rodents)6,7. The cardiomyocytes then grow massively, with 10-fold to 20-fold increases in cell volume (hypertrophy)6. With the onset of lactation, fatty acid oxidation becomes the major source of ATP in cardiomyocytes, and mitochondria proliferate to occupy ${ \sim } 3 0 \%$ of the cell volume8. Much of the growth in cell size is due to the increase in the contractile machinery, which consists of highly aligned myofibrils with sarcomeres in a precise arrangement9. The repertoire of ion channels in the sarcolemma is remodelled, such that automaticity is lost everywhere but in specialized pacemaking centres (such as the sinoatrial and atrioventricular nodes)10,11. Simple caveolae in immature cells undergo deep invagination to the core of the maturing cell, creating the T-tubules that bring excitation

stimuli to the contractile apparatus12. Intercellular junctions, originally circumferential, remodel into specialized electromechanical junctions at the longitudinal end of the cell, known as the intercalated discs13.

In this Review, we summarize and synthesize the current state-of-the-art approaches in hPSC-CM maturation. This field is quickly expanding so, wherever possible, we focus on the studies assessing maturation of human cardiomyocytes, but we recognize that many insights might have derived first from studies in other species. We do not discuss the use of hPSC-CMs in drug development, disease modelling or regeneration per se, although we take lessons from these areas to highlight unmet needs and to provide insights into the mechanisms of cardiomyocyte maturation. We begin with a discussion of the hallmarks of cardiomyocyte maturation, then highlight studies in which cardiomyocyte maturation has been controlled experimentally, summarize our current understanding of maturation from a systems biology perspective and conclude with thoughts on future prospects for the field.

# Properties of maturing cardiomyocytes

# Morphology.

The growing heart undergoes substantial morphological changes at the cardiomyocyte level. Growth of the prenatal heart is predominantly driven by cardiomyocyte proliferation (hyperplasia). In the first week of postnatal life in rodents, and during the first decade in humans, cardiomyocytes undergo mitotic quiescence, and further growth of the heart occurs principally by increasing cardiomyocyte size14,15. The developing cardiomyocyte coalesces with adjacent cardiomyocytes to assemble an electromechanical functional syncytium through well-characterized gap junctions and adhesive junctions that form the myocardium. Standard differentiation of hPSC-CMs in in vitro culture lacks the dynamic physical and environmental cues necessary to induce the degree of physiological hypertrophy observed in vivo from postnatal stages into adulthood, even after prolonged culture16–18. As such, use of standard cell culture protocols results in heterogeneous cell populations of small, misaligned, immature cardiomyocytes of varied shape, generally lacking the well-formed myofibrils and T-tubules, polyploidy, polarized intercalated discs or abundant mitochondria seen in vivo19 (FIG. 1; TABLE 1).

The adult cardiomyocyte in vivo has a large, anisotropic, rod-like shape that is approximately $1 5 0 \mu \mathrm { m }$ in length, $2 0 \mu \mathrm { m }$ in width, $1 5 \mu \mathrm { m }$ in height and $4 0 { , } 0 0 0 \mu \mathrm { m } ^ { 3 }$ in volume20. By contrast, cultured hPSC-CMs range from circular cells with diameters of 5–10 $\mu \mathrm { m }$ and heights of ${ \sim } 5 \mu \mathrm { m }$ at the start of spontaneous beating, to oblong cells measuring 30 $\mu \mathrm { m }$ in length, $1 0 \mu \mathrm { m }$ in width and $2 { , } 0 0 0 \mu \mathrm { m } ^ { 3 }$ in volume after prolonged culture21. Adult cardiomyocyte morphology not only provides the structural framework of the cell but also directly establishes other critical functional properties of the cell such as electrophysiology and contractility. For example, membrane capacitance is directly proportional to cell surface area, such that smaller cardiomyocytes have lower impulse propagation velocity and a reduced maximal action potential upstroke velocity than larger cells22,23. The elongated, anisotropic shape results in a high length to width ratio that enables the presence of long myofibrils with laterally registered sarcomeres, granting efficient cardiac contractility24. Although immature cardiomyocytes in vivo can have a similar rod-like morphology to adult cardiomyocytes, when isolated and placed in 2D culture they quickly adopt flattened, heterogeneous shapes without clear myofibril alignment25,26. Therefore, differences in structure between immature and mature cardiomyocytes lead to functional variances that limit the potential of hPSC-CMs to recapitulate normal development or model human disease and thus limit their use in therapeutic regeneration strategies.

# Electrophysiology.

The cardiomyocyte action potential results from inward and outward passage of ions through sarcolemmal ion channels. During heart development, the expression levels, location and function of distinct ion channels in cardiomyocytes evolve over time into a mature electrophysiological phenotype27. Whereas the adult primary ventricular cardiomyocyte is electrically quiescent until triggered by the depolarization of a neighbouring cell, the immature hPSC-CM beats spontaneously. This automaticity is due to the high levels of hyperpolarization-activated cyclic nucleotide-gated channel 4 (HCN4) in the plasma membrane, known as the ‘voltage clock’, which is driven by sodium influx and is a characteristic of pacemaking cells, as well as to the spontaneous leak of calcium from the sarcoplasmic reticulum that triggers electrogenic sodium–calcium exchange at the sarcolemma (known as the ‘calcium clock’)28.

The action potentials generated from an immature hPSC-CM and a mature primary cardiomyocyte are quite distinct29,30 (FIG. 2). The resting membrane potential is less hyperpolarized in immature hPSC-CMs (approximately $- 6 0 \mathrm { m V } ,$ , similar to that of nodal cells) than in mature ventricular cardiomyocytes (approximately $- 9 0 \mathrm { m V }$ ). The less hyperpolarized, maximal diastolic potential in immature hPSC-CMs is due to low levels of the inward-rectifier potassium current $( I _ { \mathrm { K 1 } } )$ , a current mediated by the inward-rectifier potassium channel $\mathrm { K } _ { \mathrm { i r } } 2 . 1$ (encoded by KCNJ2). $I _ { \mathrm { K 1 } }$ regulates the outward flux of potassium and functions in the re-establishment of resting membrane potential. The upstroke velocity of the action potential is much slower in immature hPSC-CMs than in mature cardiomyocytes. Early-stage hPSC-CMs mainly express the fetal isoform of the $\mathrm { N a } _ { \mathrm { v } } 1 . 5 \ : \mathrm { a } .$ - subunit of the sodium channel (encoded by $S C N 5 A ) ^ { 3 1 }$ , which leads to slower kinetics of channel activation and inactivation and, therefore, slower maximum upstroke velocity of the action potential. The less hyperpolarized resting membrane potential also contributes to a slower upstroke velocity32 as a result of fewer sodium channels that can be activated at higher membrane potentials. In immature hPSC-CMs, repolarization commences quickly after depolarization, whereas mature ventricular cardiomyocytes have a plateau phase, characterized by high levels of calcium influx via the L-type calcium channel (LTCC) $\mathrm { C a } _ { \mathrm { v } } 1 . 2$ (of which the pore-forming subunit is encoded by $C A C N A I C ) ^ { 2 7 }$ . Finally, the fast repolarization phase in immature hPSC-CMs is mostly mediated by rapid delayed-rectifier potassium currents $( I _ { \mathrm { K r } } )$ , whereas the slow delayed-rectifier potassium current $( \mathit { I } _ { \mathrm { K s } } )$ is barely detectable in these cells33,34. Pharmacological inhibition of $I _ { \mathrm { K r } }$ in hPSC-CMs leads to a significant increase in action potential duration and reduced beat rate, highlighting the prominent role of this current in membrane repolarization35. The presence of $I _ { \mathrm { K s } }$ is debated, but a number of research groups have been able to measure this current in hPSC-CMs, despite $I _ { \mathrm { K s } }$ activity being detectable only in a fraction of cells and in low quantities34,36–40. The transient outward potassium current $\scriptstyle ( I _ { \mathrm { f o } } )$ is small or absent in neonatal cardiomyocytes from most mammals but increases with age41. $I _ { \mathrm { { t o } } }$ density in hPSC-CMs is similar to that of canine epicardial myocytes but has slower kinetics, potentially explaining the lack of the notch phase preceding the opening of the LTCCs in the hPSC-CM action potential tracing41 (FIG. 2).

At the tissue level, cell–cell electrical coupling via gap junctions is required for electrical propagation. The components of the intercalated disc complex, including desmosomes, Ncadherin-mediated adherens junctions, $\mathrm { N a } _ { \mathrm { v } } 1 . 5$ and connexin 43 $\mathrm { C x } 4 3$ ; encoded by $G J A I ,$ , are circumferentially distributed in immature cardiomyocytes and, through an unknown mechanism, gradually become polarized to the ends of the cardiomyocyte during cell maturation in vivo. This polarization does not occur in standard cultured hPSC-CMs42, but polarization can be induced by spatially restricting the cells (for example, with patterned, adhesive substrates)43, by forcing the cells to elongate and to couple end-to-end through cyclic mechanical stretching44, and by the addition of support cells such as fibroblasts or bone marrow stromal cells45.

# Calcium handling.

In the adult cardiomyocyte, calcium has a predominant role in contraction, signalling, metabolism and transcriptional regulation. In excitation-contraction coupling, propagation of depolarization along the sarcolemma and its invaginations (T-tubules) induces the opening of LTCCs, which leads to an influx of extracellular calcium into the cell that results in calciuminduced calcium release from the sarcoplasmic reticulum via ryanodine receptors (RYRs)12. Once released from the sarcoplasmic reticulum, calcium binding to troponin C initiates myofilament sliding and muscle contraction. Relaxation occurs through the uptake of calcium back to the sarcoplasmic reticulum via sarcoplasmic/endoplasmic reticulum calcium ATPase 2a (SERCA2a) and export out of the cell via the sodium–calcium exchanger, with minor uptake into the mitochondria and additional efflux by the sarcolemmal calcium ATPase. This efficient system of calcium handling is mediated by specific spatial organization of the calcium handling apparatus, bringing together LTCCs in close proximity to RYRs on the sarcoplasmic reticulum to create hubs for efficient excitation–contraction coupling across the length and width of the cell12.

By comparison, the calcium dynamics of hPSC-CMs are poorly established. The lack of Ttubules delays calcium-induced calcium release because of the spatial uncoupling of the LTCCs and $\mathrm { R Y R s } ^ { 4 6 , 4 7 }$ . During cell maturation, calcium stores in the sarcoplasmic reticulum gradually increase from day 2 to day 30 after the onset of cell beating46,48,49. Although calcium stores in the sarcoplasmic reticulum of hPSC-CMs at day 21 of differentiation are similar to those in ventricular cardiomyocytes isolated from the adult mouse or rabbit, hPSC-CMs have slower calcium dynamics, with increased time to peak and slower decay of the calcium signal48. hPSC-CMs express calcium-handling proteins, albeit at significantly lower levels than primary adult cardiomyocytes. For example, in hPSC-CMs, the levels of the LTCC $\beta .$ -subunit $\mathrm { C a } _ { \mathrm { v } } \beta 2$ are 20-fold lower46, RYR levels are 1,000-fold lower46 and the calcium-buffering protein calsequestrin is not significantly expressed50 compared with human adult left ventricular cardiomyocytes. One exception is the sodium–calcium

exchanger, which is more highly expressed at the protein level in hPSC-CMs and in human primary fetal cardiomyocytes than in human primary adult cardiomyocytes51.

# Myofilament proteins.

The development of contractile force depends on sarcomere content, spatial organization of myofibrils and myofilament sensitivity to calcium12,52. The sarcomeres in a human adult cardiomyocyte are ${ \sim } 2 . 2 \mu \mathrm { m }$ long when relaxed and align across the short axis, and are each localized between two T-tubules in close proximity to the sarcoplasmic reticulum and mitochondria53,54. In hPSC-CMs, sarcomeres are smaller $( \sim 1 . 6 5 \mu \mathrm { m } )$ and the myofibrils are poorly organized and scattered across the cytoplasm16. The formation and organization of the sarcomere relies on the expression of different myofibrillar proteins, such as titin, myosin heavy chain, $\mathbf { a }$ -actin and the troponin complex, which are less abundantly expressed or differ in isoform in fetal cardiomyocytes and PSC-CMs compared with adult ventricular cardiomyocytes55–57. During development, TTN (which encodes titin) mRNA undergoes extensive alternative splicing; adult cardiomyocytes express the short and stiff titin isoform N2B, whereas fetal cardiomyocytes and hPSC-CMs express the longer and more compliant titin isoform N2BA58.

Myosin heavy chain is also expressed in two different, developmentally regulated isoforms: the fetal $\textbf { a }$ -isoform $\mathbf { \bar { a } }$ -MHC; encoded by MYH6) and the adult $\beta$ -isoform ( $\beta$ -MHC; encoded by $M Y H 7 ) ^ { 5 9 }$ . Of note, in rodents, $\beta$ -MHC is the fetal isoform and $\mathbf { a }$ -MHC is the adult isoform. hPSC-CMs initially express the $\mathbf { a }$ -MHC isoform, characterized by fast ATPase activity and rapid actin binding, features that are needed in fetal hearts to support the faster beating, and then gradually switch to expression of $\beta$ -MHC with prolonged culture16,57,60.

Within the troponin complex, the regulatory troponin I (TnI) establishes myofibrillar calcium sensitivity in an isoform-specific manner. Studies in animal models show that cardiomyocytes express the slow skeletal muscle isoform (ssTnI; encoded by Tnni1) during embryonic development and switch to expression of the cardiac isoform (cTnI; encoded by Tnni3) after birth9.61.62; this switch has also been demonstrated during human heart development63,64. Compared with expression of cTnI, expression of ssTnI in cardiomyocytes causes a reduction in maximum tension production65,66 with altered calcium affinities67, which results in slowed relaxation.

Two cardiac muscle isoforms of myosin regulatory light chain 2 (MLC2) exist and are also developmentally regulated: a cardiac ventricular isoform (MLC2V) and a cardiac ‘atrial’ isoform (MLC2A)68,69. MLC2A is a slight misnomer because, during development, this isoform is initially expressed in all heart chambers but becomes confined to the atrium and pacemaking centres in the postnatal heart. By contrast, MLC2V is expressed only in the ventricle and is considered a maturation marker for ventricular cardiomyocytes68,69. Smooth muscle α-actin (SMA) expression peaks in early embryonic cardiomyocytes in rodents and is downregulated and undetectable postnatally70,71. In human fetal cardiomyocytes, expression of SMA is sparse, whereas SMA is replaced by cardiac actin and is thus undetectable in adult hearts72. Human embryonic stem cell-derived cardiomyocytes (hESC

CMs) express SMA in vitro, but this expression is downregulated within 1 week after transplantation into mouse hearts in a model of in vivo maturation73.

The expression profile of intermediate filament proteins also changes during development. In the human adult heart, vimentin, a type III intermediate filament protein that is responsible for maintaining cell shape, is expressed predominantly in fibroblasts and endothelial cells, but this protein can be detected in cardiomyocytes in the human fetal heart and in hPSC-CMs56,74. Vimentin expression levels drop in cardiomyocytes during fetal development and are undetectable in the adult state56,74. The levels of desmin, a musclespecific intermediate filament protein that is important for the maintenance of sarcomeres, increase during human fetal heart development74 and are abundant in the human adult cardiomyocyte56. By contrast, desmin is expressed in only a small fraction of early-stage hPSC-CMs56.

# Metabolism.

Myocardial metabolism dramatically changes during fetal to adult development. At the fetal stage, the low level of fatty acids and high level of lactate in the blood activate anaerobic glycolysis as the major source of ATP production in the heart75. During postnatal development, the increase in dietary lipid levels and oxygen concentrations in circulating blood has important roles in mediating metabolic reprogramming. Consequently, approximately $8 0 \%$ of total energy consumption in adult cardiomyocytes is supplied with $\beta$ - oxidation of fatty acids, in contrast to only $1 5 \%$ in fetal cardiomyocytes76. Importantly, lipid metabolism facilitates greater ATP production than the metabolism of carbohydrates on a per-gram basis. In the healthy adult cardiomyocyte, the majority of ATP generated $( \sim 6 0 -$ $7 0 \%$ ) supports contractile function, followed by support of the activity of SERCA and of other ion transporters77.

Mitochondria undergo dramatic changes in morphology during cardiomyocyte maturation (FIG. 1). Fetal cardiac mitochondria share similar features to those in hPSC-CMs, such as location in the perinuclear space, low numbers and small size (occupying ${ < } 5 \%$ of total cell volume), round shape and rudimentary cristae (the folds of the inner membrane of mitochondria)18,42. Metabolically, hPSC-CMs generate energy mainly from glycolysis78 (it should be noted that glucose is the principal metabolic substrate in most cell culture media). With increasing organismal age, mitochondria assume an oval shape and increase robustly in both size and number, taking up $\sim 3 0 \%$ of the cell volume in mature cardiomyocytes42. Moreover, mitochondria in adult cardiomyocytes are well organized and aligned between myofibrils and under the sarcolemma to provide ATP efficiently for contraction and ion pumps79,80. An interesting feature of mitochondria in the mouse fetal heart is that their mitochondrial permeability transition (MPT) pore is constitutively open, which reduces the mitochondrial membrane potential and their capacity for oxidative phosphorylation81. Curiously, opening of the MPT pore at this stage does not induce cytochrome $c$ leakage or apoptosis, unlike in adult mitochondria. Pharmacological closure of the MPT pore with cyclosporine A induces mitochondrial maturation, including elongation of mitochondria, an increase in mitochondrial membrane potential and a reduction of reactive oxygen species production in mouse embryonic cardiomyocytes81. Cristae are present at low density in fetal cardiomyocytes. Conversely, adult cardiomyocytes have dense cristae and, therefore, acquire sufficient surface area for mitochondrial respiration8,82. These morphological alterations contribute to increased oxidative capacity in mature mitochondria.

# Cell cycle.

Studies in rodents and humans have demonstrated that, whereas embryonic, fetal and early postnatal cardiomyocytes can divide, adult cardiomyocytes are predominately quiescent83–86. This cell cycle arrest coincides with the switch from a hypoxic to oxygenrich environment postnatally87. During cardiomyocyte maturation in vivo, cardiomyocytes become polyploid in most mammals88 (FIG. 3), either via DNA synthesis and nuclear division without cytokinesis to form binucleated cells, as occurs in rodents86, or via DNA synthesis without nuclear division to make polyploid nuclei, as observed in humans6,7. Early studies demonstrated that polyploidy increases with age in human cardiomyocytes, ranging from 4n to $6 4 \mathrm { n }$ (where $\boldsymbol { n }$ is the haploid content of chromosomes; reviewed previously15), and the number of polyploid cells increases after injury such as myocardial infarction83,89,90. Mounting evidence suggests that polyploidy of cardiomyocytes might be negatively correlated with regenerative potential. Patterson et al. demonstrated that mouse strains with higher levels of diploid mononuclear cardiomyocytes had increased regenerative potential compared with strains with lower levels of cardiomyocyte diploidy91. In a 2018 study, Gonzalez-Rosa and colleagues developed a system in zebrafish in which the ploidy of cardiomyocytes could be genetically tuned. The researchers showed that hearts with genetically increased levels of ploidy had less regenerative potential than wild-type control hearts92. At present, very little is known about the regulation of polyploidization, but evolutionary evidence points to a shift from ectothermy to endothermy and correlation with the rise in thyroid hormone concentrations as a factor contributing to cardiomyocyte cell cycle exit and polyploidy88. The functional roles of polyploidization and its effect on cellular physiology remain ripe for discovery.

Multiple levels of regulation of the cardiac cell cycle have been described, including classic regulators such as cyclins, cyclin-dependent kinases (CDKs) and CDK inhibitors (CKIs), along with microRNas (miRNAs), transcription factors and metabolic regulators. In humans and rodents, cyclin and CDK levels (along with CDK phosphorylation activity) decrease during fetal to adult cardiomyocyte maturation, reflecting the loss of proliferative capacity93–96. Studies investigating CKI expression have shown more heterogeneous results but, in general, CKI expression tends to increase from fetal to adult cardiomyocyte development (with a major exception being p57, which decreases during both human and rat development)96–98. Similarly, the levels of cyclins and CDKs decrease during hPSC-CM differentiation99. However, hPSC-CMs retain the capacity to divide for months after their generation, with proliferation rates gradually decreasing from $3 0 \%$ to ${ < } 5 \%$ per day after prolonged culture21,100–103.

Distinct miRNAs have been shown to either promote or inhibit cardiomyocyte proliferation. A whole-genome miRNA screen in human induced pluripotent stem cell (hiPSC)-derived cardiomyocytes (hiPSC-CMs) identified 67 miRNAs that affect DNA synthesis and cell division, 53 of which depended on the Hippo pathway transcription factor Yes-associated protein $\mathrm { ( Y A P ) ^ { 1 0 4 } }$ . This finding highlights the critical role of Hippo-induced YAP repression during cardiac cell cycle arrest105. In addition, cardiomyocyte-specific overexpression of Meis1, which encodes a transcription factor involved in cardiac development, in mouse hearts was shown to decrease cardiomyocyte proliferation and activate CKIs compared with cardiomyocytes from control hearts106.

Metabolism also contributes to cell cycle activity. Low glucose levels or fatty acid or thyroid hormone supplementation can suppress hPSC-CM proliferation103,107,108. Many groups have utilized positive regulators of the cell cycle to promote the proliferation of adult cardiomyocytes in animal models and in vitro, including overexpression of D-type cyclins109,110 and the combined overexpression of CDK1, CDK4, cyclin B and cyclin $\mathbf { D } ^ { 1 0 2 }$ . The capacity of hPSC-CMs to divide could prove a powerful tool compared with more traditional models to elucidate the mechanisms of cell cycle control in cardiomyocytes (Box 2). These discoveries will not only increase our knowledge of cardiac maturation, but potentially can reveal therapeutic targets to induce division of host cardiomyocytes in disease states or that can be exploited to amplify the grafted cells after hPSC-CM transplantation in the injured heart.

# Approaches for cardiomyocyte maturation

# Long-term culture.

Long-term culture was the first approach used to mature PSC-CMs. In initial experiments, cardiomyocytes derived from differentiation of human embryoid bodies were maintained in culture for up to 60 days, and the cells showed many structural changes, including changes in sarcomeric organization and increased cell size, as well as reduced proliferation21. Indepth characterization of culture times for cardiomyocytes that were derived from hPSCs with the use of 2D differentiation protocols (1 month to 3–4 months in culture) showed the development of additional maturation features, including increased cell size, myofibril alignment, cell elongation and contractile performance and improved calcium handling, action potential amplitudes and upstroke velocity16. The majority of these maturation changes occur between 1 week and 4 weeks, whereas a modest change is observed after 4 weeks, at which point gene expression trends stabilize21,69. These hPSC-CMs can be cultured for at least 1 year and demonstrate gradual increases in the ratio of MLC2V to MLV2A, indicative of ventricular specification, as well as increases in sarcomeric organization with emergence of the M line at 1 year111. Although long-term culture improves many facets of cardiomyocyte maturation, these long-term culture methods are still not sufficient to induce T-tubule development16,21. RNA sequencing studies (discussed below) have shed light on the changes that occur with ageing of hPSC-CMs in culture and have identified candidate transcription factors112,113 and miRNAs114 that are important for hPSC-CM maturation. In summary, the positive attributes of long-term culture are that the method is simple and permits some degree of cardiomyocyte maturation. On the negative side, long-term culture is time-consuming, yields a high variability in the degree of maturation achieved (with only a subset of cells in culture truly maturing112) and the underlying mechanisms of this maturation are unclear.

# In vivo studies: transplantation and mosaic knockout models.

hPSC-CMs mature extensively when transplanted into a normal or injured heart. Our group studied the in vivo maturation of hiPSC-CMs transplanted into rat neonatal and adult hearts115. The hiPSC-CMs underwent hypertrophy, increased myofibril content and bundling, sarcomere lengthening and polarization of intercalated discs (containing $\mathbf { C } \mathbf { { x } } 4 3 ^ { + }$ gap junctions and N-cadherin-positive adhesive junctions), and switched from the fetal ssTnI to the mature cTnI isoform115. Matching the graft and host species seems to be important. Rat neonatal cardiomyocytes transplanted into rat hosts displayed more mature phenotypes, whereas a human cell graft remained relatively immature. Conversely, hPSC-CMs achieved a nearly adult-like structure and contractile protein isoform composition at 3 months after grafting into infarcted hearts of adult macaque monkeys and, importantly, restored systolic function1. Cho and colleagues transplanted both human and mouse PSC-CMs into hearts of rats lacking a normal thymus and functionally mature T cells and found that the cardiomyocytes had more mature morphology after only 1 month, characterized by $\mathrm { C x } 4 3$ expression, T-tubule formation and faster calcium dynamics116. Contrary to our study findings, these results suggest that neonatal hearts might promote better in vivo maturation than adult hosts. Following a wave of cell death immediately after transplantation, the engrafted hPSC-CMs undergo rapid proliferation followed by a plateau in cell numbers117,118, and the transition to maturity is characterized by increases in cell size and volume and by structural reorganization analogous to the physiological hyperplasia-tohypertrophy transition that occurs during normal heart development.

In 2018, our group reported on the long-term benefit for cardiac function and cell maturation of large hESC-CM grafts transplanted into the infarcted hearts of non-human primates1. Paralleling the benefit in improving cardiac contractile function seen between 1 month and 3 months after transplantation, the hESC-CM grafts continued to mature over time1,119. In vivo hESC-CM maturation resulted in increases in sarcomeric organization over 3 months and led to eventual functional and electrical integration with host cells after a period of arrhythmogenicity. Similar results have been reported in an allogeneic, non-human primate model that used rhesus monkey iPSC-CMs120. In settings of subacute myocardial infarction, the embryonic-like quality of hPSC-CMs might harbour a beneficial phenotype to survive the hostile environment of the myocardium after infarction and to engraft effectively26,121. Identification and inclusion of the critical developmental cues required for adequate cardiomyocyte maturation in a context-sensitive manner is, therefore, needed for further advancement of in vitro differentiation technologies.

The study of in vivo postnatal development is providing important insights into cardiomyocyte maturation. Guo and colleagues performed a CRISPR–Cas9 in vivo screen in mice, knocking out specific genes at low frequency to prevent global cardiac dysfunction122. The research team demonstrated that serum response factor (SRF) regulates T-tubule formation, sarcomere spacing, cell hypertrophy and mitochondrial biogenesis specifically in the mouse neonatal heart122. Srf knockout in the adult mouse had little effect, indicating distinct SRF regulatory pathways in neonatal growth versus adult cardiac homeostasis122. Myh6 seems to be a key gene downstream of SRF, because Myh6knockout in mice phenocopied the Srf knockout. This study highlights not only the developmental, stage

specific effects of SRF on cardiac phenotype but the critical window of optimal SRF levels that is needed for cardiomyocyte maturation. These insights will be important to consider as additional gene regulatory pathways are identified.

Together, these studies demonstrate that hPSC-CMs have no intrinsic limitations in their capacity to develop properties of postnatal cardiomyocytes. When placed into their natural environment (that is, the adult myocardium), hPSC-CMs undergo accelerated maturation and assume nearly adult-like structure, function and gene expression profile. The mechanism for this accelerated maturation is currently unknown and could include electromechanical conditioning, chemical signalling through gap junctions, paracrine signals from nearby cells and systemic factors such as neurohormones and metabolic fuels.

# Biophysical cues and intercellular crosstalk.

The capacity of hPSC-CMs to mature to an essentially adult phenotype after transplantation indicates that standard cell culture conditions are missing critical elements from the in vivo environment. This limitation has been recognized for many years, illustrated, for example, by the observation that isolated adult cardiomyocytes either die or dedifferentiate within a few days of being placed in culture123–125. As a result, many investigators are developing improved in vitro systems to recapitulate better the in vivo myocardium environment.

The anisotropic, rod-like shape of mature adult cardiomyocytes facilitates myofibril alignment and contractility. To promote these features, 2D hPSC-CM cultures can be forced into rectangular shapes by printing adhesive micropatterns43,126 or building nanogrooves into the culture substrates127–129. Ribeiro and colleagues showed that use of micropatterned, adhesive rectangles of specific ratios of length to width (for example, 7:1) as a substrate causes the hPSC-CMs to align their myofibrils, increase the force generation, display longitudinal calcium propagation, increase their mitochondrial content and have a more mature electrophysiological profile, indicated by a more negative resting membrane potential and increased action potential amplitude and upstroke velocity126. Kim and colleagues used nanogrooved substrates to facilitate the elongation and directionality of rat neonatal cardiomyocyte monolayers, which recapitulated many in vivo structural features and resulted in the development of directional propagation of action potential and calcium waves127. Similar findings were observed when hiPSC-CMs were plated on nanogrooved substrates128,129. Plating densities also have been shown to influence maturation. Comparison between hPSC-CMs grown in small or large islands (by surface area) showed that the size of cardiomyocyte islands is proportional to the electrical maturation of the cells, indicated by action potential voltage and calcium peak amplitudes and the upregulation of the expression of genes encoding contractile and mitochondrial proteins130. These differences were suggested to be mediated by mechanical and biochemical cues from direct contact with neighbouring cells. Consistent features among most of these studies testing the patterning of culture substrate include increased sarcomere alignment and organization and improved calcium dynamics, despite only a modest influence on gene expression126,129,131. This finding suggests that some elements of maturation relate to post-transcriptional events, such as organization of the contractile cytoskeleton.

Native adult cardiac tissue has an elastic modulus of ${ \sim } 1 0 \mathrm { k P a }$ $( \mathrm { R e F S } ^ { 1 2 6 , 1 3 2 } )$ . Culturing hPSC-CMs close to these conditions (plated on ${ \sim } 1 6 \ – \mathrm { k P a }$ polyacrylamide gels) induced better sarcomere alignment and improved calcium handling compared with softer hydrogels (4-kPa gel)133. Feaster and colleagues compared the maturation state of hiPSC-CMs that were plated on thick beds of concentrated Matrigel $( { \sim } 5 . 8 \mathrm { k P a } )$ with that of hiPSC-CMs generated conventionally on 1:60 diluted Matrigel (which essentially provides the same stiffness of the underlying tissue culture plastic, specifically $0 . 5 { - } 1 . 0 \mathrm { M P a } ) ^ { 1 3 4 }$ . The researchers found improved contractility, expression of genes encoding myofibril proteins, sarcomere alignment and depolarization rates in the cells cultured on concentrated Matrigel. Although the more physiological substrate stiffness is likely to have a major role in promoting maturation, chemical signals from the concentrated Matrigel cannot be ruled out. Herron and colleagues compared hiPSC-CMs cultured on glass $\mathrm { ( { > } 1 \ G P a ) }$ versus hard polydimethylsiloxane (PDMS; ${ \sim } 1 \ \mathrm { M P a }$ ) substrates, coated with either fibronectin or Matrigel135. The investigators found that culture on Matrigel-coated PDMS, but not the other conditions, induced an increase in the expression of ion-channel genes (such as SCN5A and KCNJ2) and in the levels of the associated currents (the sodium current $\left( { { I _ { \mathrm { { N a } } } } } \right)$ and the $I _ { \mathrm { K 1 } } \mathrm { \dot { } }$ ) and promoted hypertrophy, binucleation and cell cycle exit. These effects could be blocked by $\beta 1$ -integrin-neutralizing antibodies and focal adhesion kinase inhibition, implying the involvement of integrin-mediated pathways135. Although the researchers attributed the promaturation effects to the flexibility of the PDMS substrate, ${ \sim } 1 \ \mathrm { M P a }$ is essentially inflexible to a cardiomyocyte, so the difference observed in this study might relate to integrin signals available through the Matrigel that are inhibited by the highly charged glass substrate.

During heart development, the presence of noncardiac cells, such as fibroblasts, endothelial cells, smooth muscle cells, neurons and immune cells, actively contributes to cardiomyocyte maturation through cell–cell interactions and/or paracrine signals136–141. Ieda and colleagues demonstrated that cardiac fibroblasts in mice have stage-specific roles: early embryonic fibroblasts promote the proliferation of cardiomyocytes by secretion of extracellular matrix factors, whereas adult fibroblasts induce cardiomyocyte hypertrophy and sarcomere organization by secreting growth cytokines137. Like cardiomyocytes, fibroblasts are mechanoresponsive cells that respond to substrate stiffness and dynamic strain. Mouse adult cardiac fibroblasts maintained in standard 2D culture have an activated, myofibroblastlike phenotype, characterized by higher cell cycle activity, higher SMA and calponin protein levels and increased collagen production compared with fibroblasts cultured in 3D aggregates142. Switching from soft to stiff cell culture substrates, mechanical stretching and co-culture with neonatal cardiomyocytes can increase extracellular matrix production, cell spreading and proliferation of mouse cardiac fibroblasts143. Co-culturing mouse ESC-CMs with endothelial cells leads to increased levels of $\mathbf { a }$ -MHC (the predominant adult isoform in rodents) and improved calcium kinetics and sarcomere alignment144. Mechanistic studies revealed that endothelial cells induce the expression of multiple miRNAs in cardiomyocytes, and that the cardiomyocyte maturation phenotype can be recapitulated in hPSC-CMs by delivering four of these miRNAs as a cocktail (miR-125b-5p, miR-199a-5p, miR-221 and miR-222). Interestingly, some of the benefits on cardiomyocyte maturation of co-culture with endothelial cells are specific to the hPSC-CM differentiation stage at which the

endothelial cells are introduced. Dunn and colleagues found that co-culture of hPSC-derived endothelial cells with hPSC-derived cardiac progenitor cells had a greater maturation effect than co-culture with more differentiated, beating hPSC-CMs, including on cardiomyocyte size, expression of genes encoding sarcomeric and ion channel proteins, and chronotropic responses to drugs145. Further studies are needed with other cell types, including smooth muscle cells and peripheral neurons, to identify the roles of these cells in inducing cardiomyocyte maturation. Together, these studies indicate that recapitulating the intercellular crosstalk present in the myocardium in vivo by co-culturing hPSC-CMs with fibroblasts and endothelial cells, as well as controlling the cell shape, stiffness and nanotopology of the substrate, can improve hPSC-CM maturation. The mechanisms underlying these beneficial effects are just beginning to emerge.

# Moving to 3D cultures: engineered heart tissues, mechanical loading and e-stimulation.

Differentiation and growth of hPSC-CM monolayers is popular because of the simplicity and moderate scalability of this method for cardiomyocyte production. However, the heart is a 3D organ and this architecture facilitates cardiac development, in part because the cells can maintain natural contact with each other and the extracellular matrix that is not possible in the 2D environment of standard cell culture146. A number of groups have demonstrated the benefits of culturing hPSC-CMs in 3D systems (such as engineered tissues and organoids) to enhance the maturation state and, to date, 3D systems have been arguably the most successful methods to boost maturation in vitro147–154. As hPSC-CM differentiation protocols improved, it became clear that highly pure cardiomyocyte preparations form poor tissues when cast into collagen or fibrin hydrogels. Fibroblasts or other stromal cells are needed to remodel the extracellular matrix and compact the gels into tissues. A systematic analysis by Tiburcy and colleagues showed that a fibroblast seeding content of $3 0 \%$ , yielding a final cardiomyocyte content of ${ \sim } 5 0 \%$ , was optimal for force production154. However, fibroblasts vary widely depending on the tissue source. Bargehr and colleagues tested the hypothesis that cardiac fibroblasts (which arise developmentally via epithelial-tomesenchymal transition from the epicardium) would be optimally suited for tissue engineering and heart repair strategies155. The research team derived epicardial cells from hESCs and cast them into collagen hydrogels together with hESC-CMs, where the epicardial cells differentiated into cardiac fibroblast-like cells. Compared with tissues containing hESC-CMs only or hESC-CMs plus either hESC-stromal cells or bone marrow-derived mesenchymal stromal cells, the tissues with epicardial derivatives showed increased sarcomere length, greater hypertrophy and isometric contractile force production, reduced diastolic stiffness and improved calcium handling155. The presence of epicardial cells improved the capacity of the hESC-CMs for heart repair, increasing the graft size, vascular density and multiple indices of hESC-CM maturation after transplantation into infarcted rat hearts compared with transplantation of either cell type alone. Moreover, transplantation of epicardial cells plus hESC-CMs increased the recovery of ventricular function compared with engraftment of either cell type alone. Therefore, judicious use of stromal cells can enhance hPSC-CM maturation, which will facilitate the generation of better cardiac muscle in vitro and in vivo.

In an attempt to further increase cellular complexity, Ravenscroft and colleagues showed that co-culture of hPSC-CMs with primary cardiac fibroblasts and endothelial cells as microtissues (scaffold-free aggregates) is associated with a more adult-like response to pharmacological agents compared with cardiomyocyte-only microtissues156. Giacomelli et al. also generated microtissues composed of cardiomyocytes and endothelial cells derived from hPSCs and found upregulation of genes related to sarcomeric assembly, ion channels and calcium handling from microtissues (either cardiomyocytes only or with endothelial cells) compared with cardiomyocyte monolayers157. Shadrin and colleagues created cardiac patches by casting hPSC-CMs, smooth muscle cells and fibroblasts in a fibrin–Matrigel scaffold supported by a flexible nylon frame100. Over a 3-week culture period, the patches showed increased maturation, with the hPSC-CMs presenting organized cross-striations, upregulation of MLC2V expression, polarization of N-cadherin to intercalated disc-like structures, increased conduction velocity from $1 3 \mathrm { c m / s }$ to $2 5 \mathrm { c m / s }$ , and increased force generation from $3 \mathrm { m N / m m } ^ { 2 }$ to $1 3 \mathrm { m N / m m } ^ { 2 }$ .

During development, fetal growth imparts increasing amounts of mechanical stress on the heart, which probably induces maturation and increases contractile function158,159. Conversely, as mentioned above, in vitro culture of adult primary cardiomyocytes without mechanical loading induces sarcomere disassembly and decreases contractile function160. With the advent of engineered heart tissues (EHTs), static and cyclic stress could be studied systematically in a 3D context147,161. Our group demonstrated that subjecting hiPSC-derived EHTs to mechanical stimulation resulted in cardiomyocyte hypertrophy and alignment, with cyclic stress generally having a greater effect than static stress162. Moreover, these EHTs demonstrated the Frank–Starling relationship, increasing their twitch force in response to increasing diastolic length162. Zhang and colleagues also found that cyclic stretch, compared with static stretch, has added benefits of increasing force production and sarcomere length in EHTs composed of hPSC-CMs and stromal cells45.

The force–frequency relationship is a particularly useful parameter for assessing EHT maturity because this property integrates multiple elements of excitation–contraction coupling. This relationship is negative in immature EHTs163, flat in the hearts of newborn babies (aged $^ { < 2 }$ weeks) and becomes positive 3 months after birth164. Ruan and colleagues demonstrated that static-stress conditioning brings the force–frequency relationship in human EHTs from negative to flat, indicating considerable maturation of excitation– contraction coupling163. Leonard et al. tested the effects of afterload by attaching EHTs to flexible posts of varying stiffness165. Calcium handling, auxotonic contraction and mRNA markers of maturation increased with increasing afterload. Ronaldson-Bouchard et al. demonstrated that hPSC-CMs cast into collagen-based EHTs and subjected to auxotonic mechanical conditioning have significantly improved maturation, including formation of the diad T-tubular system, elongated myofibres associated with a high ratio of twitch-to-resting tension and a strong $\beta$ -adrenergic inotropic response148. Since the publication of their study, the EHT protocol has been standardized, defining specific cell culture conditions and implementing defined small molecules that increase the contractile function of hPSC$\mathrm { C M s } ^ { 1 5 4 }$ . Notably, EHTs matured in this optimized system have a positive force–frequency relationship, increasing the developed tension as the beating frequency increases.

Electrical stimulation has emerged as one of the most robust techniques to mature cardiomyocytes in vitro. Early work from Vunjak-Novakovic’s group showed that electrical field stimulation enhanced cell alignment and sarcomere structure of rat neonatal cardiomyocytes in 2D culture166, which has inspired testing in subsequent studies of the effect of frequency, duration and timing on the regulation of maturation in hPSC-derived EHTs. Ramping up the pacing frequency over multiple days seems to induce greater maturation than fixed-rate pacing. For example, the application of electrical stimulation in rat neonatal cardiomyocytes at close to physiological frequencies improves contractility, calcium handling and T-tubule formation and promotes a positive force–frequency relationship167. After the publication of this study, the protocols have been adapted for hPSC experiments. Nunes and colleagues reported that progressively increasing pacing from $1 \ \mathrm { H z }$ to $6 \mathrm { H z }$ over 1 week with the use of the ‘Biowire’ device (hPSC-CMs seeded with endothelial and stromal cells on top of a surgical suture) improved multiple aspects of maturation, including sarcomere organization, calcium handling, conduction velocity, reduction of proliferation rates and induction of a more negative resting membrane potential and increased action potential amplitude168. An obstacle that remained with this system was the absence of M lines or T-tubules in the cells. The latest version of this platform accommodates modelling of both hPSC-derived atrial and ventricular cardiomyocytes169. A similar approach using fixed-rate stimulation confirmed some of these results and also demonstrated that the beneficial maturation effects of electrical stimulation can persist for 2 weeks after the stimulation is removed170. Ruan and colleagues combined static mechanical loading with fixed-rate electronic stimulation and found additive effects on hPSC-derived EHT contractility, independent of hypertrophy or expression of genes related to contractile function or calcium handling163. Ronaldson-Bouchard et al. used a ramped electrical stimulation scheme (which they termed ‘intensity training’, in which the frequency is increased from $2 \ : \mathrm { H z }$ to $6 \mathrm { H z }$ over 2 weeks, followed by 1 week at $2 \ : \mathrm { H z }$ ), in combination with mechanical loading via flexible posts, to generate hPSC-derived EHTs with remarkable structural maturity148. These hPSC-CMs were adult-like in size, were replete with myofibrils with adult-like sarcomere lengths, had a full complement of T-tubules, contained numerous intermyofibrillar mitochondria with densely packed cristae and were organized into cardiomyocyte bundles with architecture closely resembling the in vivo myocardium. The mRNA expression profiles for genes related to contraction, electrical conduction, calcium handling and metabolic functions approached levels observed in adult ventricular tissue. Patch-clamp studies of the hPSC-CMs showed typical ventricular action potential tracings with a spike-and-dome appearance, although their maximum diastolic potential $( - 7 0 \mathrm { m V } )$ ) was less negative, the mean upstroke velocity $( { \sim } 2 0 \mathrm { v } / \mathrm { s } )$ ) was slower and the action potential duration $( \mathrm { A P D } _ { 9 0 } \sim 5 0 0 \mathrm { m s } )$ ) was significantly shorter than those in adult cardiomyocytes. These intensity-trained tissues had a positive force–frequency response, although their overall force production was only ${ \sim } 1 0 \%$ of the levels reported in the human adult myocardium $( { \sim } 4 4 \ \mathrm { m N } / \mathrm { m m } ^ { 2 } ) ^ { 1 7 1 }$ . Interestingly, this intensity training was most successful for engineered heart tissues derived from ‘early-stage’ hPSC-CMs (that is, generated soon after the first spontaneous contractions are observed) but not for those derived from hPSC-CMs that had been in culture for longer time periods (\~4 weeks)148. As a cautionary note, the authors published an erratum in 2019 detailing numerous errors in the original manuscript, including the use of an in vivo electron micrograph that was described as EHT172.

In summary, hPSC-CMs are highly responsive to the 3D environment as well as electrical and mechanical stimuli, and this responsiveness can be used to promote maturation. Although this finding makes intuitive sense, the molecular mechanisms underlying this response are just starting to emerge. Both electrical and mechanical cues can regulate the expression of genes encoding myofibril, ion channel and metabolic proteins, implying the involvement of at least partially overlapping regulatory pathways in the nucleus. In practical terms, the more matured state achieved by recreating critical elements of the in vivo cardiomyocyte microenvironment renders EHTs more suitable for pharmacological studies as well as for understanding the mechanism behind the increased maturation status. One limitation is that, compared with other maturation techniques, tissue-engineering approaches are less widely accessible, require engineering expertise, take considerable time ( ${ > } 1$ month to set up) and make downstream analysis more difficult (for example, imaging thick tissue or isolating cardiomyocytes for analysis from their 3D environment for some assays). Finally, as currently performed, these techniques would be challenging to scale up for cell therapy applications.

# Metabolic and hormonal interventions.

Metabolism has emerged in the past 5 years as a crucial regulator of in vitro cardiac maturation by inducing more adult-like gene expression patterns, hypertrophy and cell cycle exit108. Modulating hormonal signalling and carbon substrate availability in cell culture is straightforward and, as a result, this field is making rapid progress.

Rises in metabolic hormone levels around the time of birth coincide with maturation of cardiac properties and have been translatable to in vitro PSC-CM assays. The levels of the thyroid hormone tri-iodothyronine $( \mathrm { T } _ { 3 } )$ rise sharply after birth, and this hormonal axis is essential for normal heart function173. Treatment with $\mathrm { T } _ { 3 }$ strongly improves the maturation of hiPSC-CMs in vitro, increasing cell size, sarcomere length, contractile force, calciumtransient kinetics, mitochondrial biogenesis and mitochondrial respiration capacity, and promoting cell cycle withdrawal103. Endogenous glucocorticoid synthesis peaks before birth and remains elevated postnatally, facilitating heart maturation174,175. Studies in mouse fetal cardiomyocytes show that administration of glucocorticoids improves myofibrillar structure, oxygen consumption, ion-channel expression levels and contractility via induction of peroxisome proliferator-activated receptor- $\gamma$ co-activator 1α (PGC1α) expression174, a protein known to drive mitochondrial biogenesis during cardiomyocyte differentiation from $\mathrm { { h E S C s ^ { 1 7 6 } } }$ . Moreover, glucocorticoid hormones and $\mathrm { T } _ { 3 }$ can synergistically induce the formation of T-tubules and improve calcium kinetics in $\mathrm { { h P S C - C M s ^ { 1 7 7 } } }$ . Angiotensin II, a peptide hormone that regulates blood pressure, can induce the maturation of hESC-CMs by promoting hypertrophy, increasing the expression of genes encoding sarcomere proteins and improving sarcomeric organization178,179.

Additional factors, including insulin-like growth factor 1 (IGF1) and neuregulin $1 \beta$ (NRG1), are known to promote physiological cardiomyocyte hypertrophy180. IGF1, which can be produced locally in the heart or delivered via the circulation, activates the RAS–RA-MEK–

ERK, PI3K–AKT–mTOR or PLC– $\cdot \mathrm { I P } _ { 3 } .$ –DAG pathways to regulate hypertrophy, metabolism and contractility in the heart181. However, although IGF1 promotes all these maturation indices, this growth factor also promotes cell proliferation through the activation of the PI3K–AKT pathway182. Likewise, NRG1 has a crucial role in cardiac muscle development, including formation of the ventricular trabeculae layer and endocardial cushion183–185 (Box 1). Rupert and Coulombe showed that treatment with NRG1 strongly promoted cell growth and metabolic remodelling in hESC-CMs186. The force-frequency relationship was improved when hESC-CMs were treated with NRG1 in combination with IGF1 but, curiously, total force production was reduced186.

The switch from glycolysis to fatty acid oxidation in the heart after birth can be mimicked in PSC-CM culture. Supplementation of fatty acids as the main energy source in the culture medium has been used to facilitate maturation. Yang and colleagues treated hPSC-CMs with a cocktail of fatty acids (palmitate, oleate and linoleate) and found that this treatment increased cell size, membrane capacitance, single-cell force production, calcium handling and action potential upstroke velocity187. Mills et al. screened for an optimal maturation medium with the use of hPSC-derived cardiac organoids and identified high palmitate content with low glucose content as the most suitable medium for driving metabolic, functional and cell cycle maturation108. This medium induced a significant shift towards postnatal gene and protein expression patterns and increased oxidative phosphorylation and calcium kinetics. Correia et al. also found that fatty acid-rich medium promoted adult-like properties in hPSC-CMs, including dense mitochondria with lamellar cristae, activated oxidative phosphorylation, well-defined sarcomeres and increased binucleation, calciumtransient velocity and contractile force generation101. An interesting study from the Nakano group showed that glucose deprivation in hPSC-CMs strongly promoted cardiac structural, metabolic and functional maturation107. A detailed biochemical investigation revealed that high glucose levels induced nucleotide biosynthesis in hPSC-CMs through activation of the pentose phosphate pathway. Supplementation of uridine for nucleotide biosynthesis blocked the promaturation effect of low glucose levels and promoted cardiomyocyte cell cycle activity. The high glucose levels in standard culture media activate hypoxia-inducible factor 1α (HIF1α), a central regulator of metabolism, thereby activating glycolysis and suppressing oxidative phosphorylation188–190 via upregulation of lactate dehydrogenase191. Conversely, suppression of HIF1α signalling is crucial for the postnatal switch from glycolysis to oxidative phosphorylation192.

In summary, hormonal signalling and metabolic substrate selection can markedly augment the maturation of hPSC-CMs at the levels of gene expression profile, hypertrophic growth, cell cycle withdrawal, contractile function, electrophysiological function and metabolic networks. The cytoplasmic and nuclear regulators of this response are just beginning to be elucidated and seem to involve multiple pathways, including nucleotide biosynthesis, metabolic sensing, protein synthesis and mitochondrial biogenesis.

# Systems level analysis of maturation

# Transcriptome.

With the advent of next-generation sequencing technology and global ‘omics’ profiling, the field of hPSC-CM maturation has gained insight into the state of the differentiated cells (TABLE 2). Microarray analysis demonstrated the similarity of hPSC-CMs with cardiomyocytes in human embryonic hearts in the first trimester of development193. Furthermore, upon treatment with $\mathrm { T } _ { 3 }$ , hPSC-CMs acquire early fetal-like features and, at the level of gene expression, resemble cardiomyocytes from hearts in the second trimester of development193. Uosaki and colleagues performed an elegant analysis of 200 microarray datasets from wild-type mouse hearts across different stages of development (from embryo to adult) to characterize gene regulatory networks99. These analyses revealed that mouse PSC-CMs at day 10 of in vitro culture reflect early embryonic stages (representative of embryonic day (E)8–E11) whereas day 20 and day 30 cells seem to be arrested at the late embryonic stage (E16–E18). Candidate genes that might affect mouse PSC-CM maturation were identified, such as Ppara, Pparg, Ppargc1a, Cebpa, Cebpb (whose expression increased during in vivo cardiomyocyte development but was inactivated in mouse PSC-CMs) and Ctnnbl (which was inactivated during in vivo cardiomyocyte development but remained active in mouse PSC-CMs)99. Single-cell RNA sequencing studies have dissected the complexity and heterogeneity among cells during differentiation and have enabled the identification of maturation-associated transcription factors112,113. For instance, HOPX is a transcriptional regulator associated with cardiomyocyte hypertrophy and found to be expressed in hPSC-CMs in long-term culture conditions112,113. Overexpression of HOPX in hPSC-CMs increases cell size, whereas HOPX knockdown blocks hypertrophy and reduces the expression of multiple maturation-associated genes encoding sarcomeric proteins113. Analysis of hPSC-CM differentiation and maturation identified subpopulations of cardiomyocytes enriched in the transcription factors COUP transcription factor 2 (also known as NR2F2), T-box transcription factor TBX5 or hairy/enhancer-of-split related with YRPW motif protein 2 (HEY2), marking early, mid and late maturation time points, respectively112. HEY2 is highly expressed in the adult heart and is important for ventricular specification in both adult cardiomyocytes in vivo and hPSC-CMs112. Altogether, these findings demonstrate that PSC-CMs are capable of maturing to some extent before reaching a roadblock that prevents further progression, limited by misregulation of transcription factor networks. These roadblocks might require environmental cues from the in vivo cardiac environment to be bypassed.

# Non-coding RNAs and epigenetics.

Non-coding RNAs are gene regulators that, by definition, are not translated. miRNA profiling of hESCs, hESC-CMs and human fetal and adult primary ventricular cardiomyocytes revealed a panel of 23 miRNAs that were highly expressed in hESC-CMs and in fetal and adult samples compared with hESCs194. Overexpression of miR-1 in hESCCMs improved electrophysiological maturation, demonstrated by the gene expression profile (upregulation of CACNA1C, KCNJ2 and RYR2 expression) and action potential recordings (fast repolarization and lower maximum diastolic potential) compared with control cells194. Kuppusamy and colleagues identified candidate maturation-associated miRNAs in hESC

CMs in prolonged 2D culture and in hESC-derived EHTs and showed that overexpression of Let-7 miRNA family members in hESC-CMs markedly increased cell size, sarcomere length and single-cell force production, and induced a switch to fatty acid metabolism114. The application of an miRNA maturation cocktail — involving overexpression of Let7i and miR-452 and knockdown of miR-122 and miR-200a — to hiPSC-CMs increased force generation, cell area and fatty acid utilization compared with control cells195. As mentioned above, the capacity of endothelial cells to induce multiple facets of mouse ESC-CM maturation led to the discovery that co-culture induces the expression of multiple miRNAs in cardiomyocytes and that an miRNA cocktail (comprising miR-125b, miR-199a, miR-221 and miR-222) is sufficient to increase cell size and binucleation, make resting membrane potential more negative, increase action potential amplitude and upregulate GJA1 and KCNJ2 expression in cardiomyocytes144 Gene regulatory analysis of cardiomyocyte differentiation indicates a negative correlation between miR-200c levels (downregulated with differentiation) and transcription factors involved in cardiac development196. miR-200c overexpression in hESC-CMs decreased the expression of genes related to calcium handling and ion channels compared with control cells, which was confirmed functionally by calcium transient measurements196. Like SRF, these RNAs have developmental stage-specific functions. Although expression of miR-1 is sufficient to promote maturation of electrophysiological properties in hESC-CMs194, miR-1 overexpression in the adult rat heart leads to arrhythmogenesis that is correlated with repression of GJA1 and KCNJ2 expression197. Further characterization of how these miRNAs function and the coregulators that determine their stage-specific effects are needed to understand better their role in maturation.

Epigenetics provide another layer of gene expression regulation through modifications to and interactions between histones, DNA and regulatory non-coding RNAs. In-depth profiling of human cardiomyocytes (at neonatal to adult stages) shows cooperation between both DNA methylation and histone post-translational modifications in regulating gene expression during cardiac development7. Chow and colleagues found that treatment of hESC-CMs with valproic acid, a histone-deacetylase inhibitor, induced global increases in the levels of histone acetylation as well as in the active-chromatin mark histone H3 trimethylated at lysine 4 (H3K4me3)198. Valproate treatment for 3 days induced a significant increase in cell size and in the expression of multiple calcium-handling and ion-channel genes compared with untreated cells. Surprisingly, these changes in gene expression did not translate into functional changes in calcium dynamics or action potential characteristics. Altogether, these findings suggest a role for histone and DNA modifications in the regulation of cardiomyocyte maturation, but in-depth characterization of targets and mechanism is still needed in hPSC-CMs. We are still in the early days of understanding how the epigenome regulates maturation but, given the increasingly sophisticated toolkit for global and locusspecific epigenetic reprogramming, this area seems ripe for progress.

# Proteome and metabolome.

Mass spectrometry analyses show similarities in the proteomes of hPSC-CMs and human fetal primary cardiomyocytes199. hPSC-CMs had the lowest levels of contractile proteins, followed by human fetal primary cardiomyocytes, and adult primary cardiomyocytes had the highest levels. Conversely, the levels of proteins involved in fatty acid metabolism were higher in adult primary cardiomyocytes but similar between fetal primary cardiomyocytes and hPSC-CMs, consistent with mRNA expression patterns199. Pathway analysis highlighted PGC1α, steroid hormone receptor ERR1 and peroxisome proliferator-activated receptor-α (PPARα) as regulators of cardiomyocyte metabolic maturation. Activation of PPARα with a small-molecule ligand increased mitochondrial membrane potential and mRNA expression of genes related to fatty acid oxidation199. Proteomic analysis of hiPSCCMs cultured for 1 month revealed the upregulation of calcium-handling and ion-channel protein levels and the switch between glycolytic and fatty acid metabolism. Despite these changes in the protein profile, the researchers observed no changes in calcium transients or cellular respiration200, suggesting additional layers of regulation.

Metabolomic analysis can be used to assess the state of the cell and identify the active pathways. Comparison of the metabolic profiles of hPSC-CMs cultured for 1 month and 3 months demonstrated distinct features of cell status and identified the increased levels of glycerophosphocholine, a product of phospholipid metabolism, as a biomarker for hPSCCM maturation201. As mentioned previously, mass spectroscopy metabolite analysis identified the downregulation of nucleotide biosynthesis mediated by the pentose phosphate pathway as a mediator of low glucose-induced hPSC-CM maturation107. Measurements of the flux of carbon sources in PSC-CMs have enabled metabolite tracing and characterization to assess how carbon sources feed into and regulate the maturation programmes of the cardiomyocyte101,202.

Taken together, the findings from these omic approaches clearly show that cardiomyocyte maturation is regulated at the level of the epigenome, coding and non-coding transcriptome, proteome and metabolome. These large datasets enable the development of computational networks that generate testable hypotheses about how cardiomyocyte maturation is controlled. Several candidates have been confirmed as major regulators of maturation, but omics analyses and computational modelling are other areas that are ripe for further discovery.

# Conclusions

Differentiation protocols of PSC-CMs have been refined such that we can efficiently and reproducibly obtain cell cultures of >90% purity and yields of up to 109 cells203–205. However, these cardiomyocytes are transcriptionally, structurally and functionally embryonic-like. Although individual interventions have pushed cardiomyocytes towards a more mature phenotype in vitro, these single approaches have not been enough. Although we initially imagined ‘maturation’ as one phenomenon, maturation is likely to be a complex trait, controlled by multiple signalling networks in the cytoplasm and nucleus. Therefore, tweaking one axis might not yield progress in another, and combinatorial approaches might be necessary. For example, specific substrates for alignment and spacing of sarcomeres, pacing and mechanical strain to train ion channels and the contractile machinery, and optimal medium composition for efficient energy source utilization might better replicate cardiomyocyte natural development and produce mature phenotypes (TABLE 1). As another example, T-tubule development remains a hallmark of cardiomyocyte maturation, mediating excitation–contraction coupling and the synchrony of cells to heart rhythm. Maturation of Ttubules depends not only on expressing the functional machinery but having cytoskeletal structural features in place to organize synchronized contraction and relaxation within the appropriate metabolic context. Such a combinatorial approach has already been applied, utilizing electrical pacing and $\mathrm { T } _ { 3 }$ treatment, showing promise in maturing rat neonatal cardiomyocytes ex vivo to an adult-like state206. However, the appropriate maturation cocktail might not simply entail a combinatorial approach but require orchestration of the timing, sequence, intensity and duration of specific interventions in order to integrate subsequent transcriptional networks that will mediate and reflect cardiac developmental programmes. EHTs with electromechanical conditioning and in vivo transplantation further augment the milieu of extracellular cues with both cell–cell contacts and paracrine-mediated signalling; however, high-throughput strategies for in vitro maturation remain a priority for reproducible, scalable and economical cardiomyocyte manufacturing. Because these approaches have enabled us to achieve the greatest maturation of hPSC-CMs, engineered tissues offer strategies to discover mechanisms that can be applied to more standard culture systems.

For clinical cell-transplantation applications, use of a fully mature cardiomyocyte might be limiting because adult cells cannot survive transplantation into the host myocardium, particularly in the context of injury207. We have found that many of the gains in maturity are reversed if the cardiomyocytes are enzymatically dispersed and replated. This dedifferentiation is likely to result in part from the collapse of the contractile cytoskeleton, which spatially disrupts electrical and mechanical function. Therefore, taking advantage of the beneficial attributes of immaturity to preserve structural malleability and proliferative capacity while maintaining electrophysiological and/or metabolic maturity might be crucial to allow the cells to survive and engraft to their host environment post-transplantation while maximizing function and safety (Box 2). In vivo maturation of hPSC-CMs might be easier and even preferable for certain applications, such as therapeutic remuscularization after myocardial infarction, provided that engraftment-associated arrhythmias can be controlled208. Each PSC-CM application seems likely to require its own optimal state of cellular maturity, and, therefore, a good understanding of the various maturation strategies will be essential to achieve desirable cardiomyocyte phenotypes.

# Acknowledgements

We thank the members of the Murry Laboratory for productive discussions on the biology of cardiac maturation. We also thank our peer-reviewers, who made this manuscript better. The authors’ work is supported in part by NIH grants R01HL128362, U54DK107979, R01HL141570, R01HL146868 and R01HL128368, an award from the Fondation Leducq Transatlantic Network of Excellence and a grant from the Robert B. McMillen Foundation. N.M. is supported by a fellowship from the Japan Society for the Promotion of Science.

# References

1. Liu YW et al. Human embryonic stem cell-derived cardiomyocytes restore function in infarcted hearts of non-human primates. Nat. Biotechnol 36, 597–605 (2018). [PubMed: 29969440] 2. Sizarov A et al. Formation of the building plan of the human heart: morphogenesis, growth, and differentiation. Circulation 123, 1125–1135 (2011). [PubMed: 21403123]

3. Marchiano S, Bertero A & Murry CE Learn from your elders: developmental biology lessons to guide maturation of stem cell-derived cardiomyocytes. Pediatr. Cardiol 40, 1367–1387 (2019). [PubMed: 31388700]   
4. Hudlicka O & Brown MD Postnatal growth of the heart and its blood vessels. J. Vasc. Res 33, 266– 287 (1996). [PubMed: 8695752]   
5. Hew KW & Keller KA Postnatal anatomical and functional development of the heart: a species comparison. Birth Defects Res. B Dev. Reprod. Toxicol 68, 309–320 (2003). [PubMed: 14666994]   
6. Mollova M et al. Cardiomyocyte proliferation contributes to heart growth in young humans. Proc. Natl Acad. Sci. USA 110, 1446–1451 (2013). [PubMed: 23302686]   
7. Gilsbach R et al. Distinct epigenetic programs regulate cardiac myocyte development and disease in the human heart in vivo. Nat. Commun 9, 391 (2018). [PubMed: 29374152]   
8. Porter GA Jr. et al. Bioenergetics, mitochondria, and cardiac myocyte differentiation. Prog. Pediatr. Cardiol 31, 75–81 (2011). [PubMed: 21603067]   
9. Siedner S et al. Developmental changes in contractility and sarcomeric proteins from the early embryonic to the adult stage in the mouse heart. J. Physiol 548, 493–505 (2003). [PubMed: 12640016]   
10. Christoffels VM, Smits GJ, Kispert A & Moorman AF Development of the pacemaker tissues of the heart. Circ. Res 106, 240–254 (2010). [PubMed: 20133910]   
11. Spater D, Hansson EM, Zangi L & Chien KR How to make a cardiomyocyte. Development 141, 4418–4431 (2014). [PubMed: 25406392]   
12. Bers DM Cardiac excitation-contraction coupling. Nature 415, 198–205 (2002). [PubMed: 11805843]   
13. Vreeker A et al. Assembly of the cardiac intercalated disk during pre- and postnatal development of the human heart. PLoS One 9, e94722 (2014). [PubMed: 24733085]   
14. Li F, Wang X, Capasso JM & Gerdes AM Rapid transition of cardiac myocytes from hyperplasia to hypertrophy during postnatal development. J. Mol. Cell Cardiol. 28, 1737–1746 (1996). [PubMed: 8877783]   
15. Laflamme MA & Murry CE Heart regeneration. Nature 473, 326–335 (2011). [PubMed: 21593865]   
16. Lundy SD, Zhu WZ, Regnier M & Laflamme MA Structural and functional maturation of cardiomyocytes derived from human pluripotent stem cells. Stem Cell Dev. 22, 1991–2002 (2013).   
17. McCain ML, Agarwal A, Nesmith HW, Nesmith AP & Parker KK Micromolded gelatin hydrogels for extended culture of engineered cardiac tissues. Biomaterials 35, 5462–5471 (2014). [PubMed: 24731714]   
18. Dai DF, Danoviz ME, Wiczer B, Laflamme MA & Tian R Mitochondrial maturation in human pluripotent stem cell derived cardiomyocytes. Stem Cell Int. 2017, 5153625 (2017).   
19. Yang X, Pabon L & Murry CE Engineering adolescence: maturation of human pluripotent stem cell-derived cardiomyocytes. Circ. Res 114, 511–523 (2014). [PubMed: 24481842]   
20. Gerdes AM et al. Structural remodeling of cardiac myocytes in patients with ischemic cardiomyopathy. Circulation 86, 426–430 (1992). [PubMed: 1638711]   
21. Snir M et al. Assessment of the ultrastructural and proliferative properties of human embryonic stem cell-derived cardiomyocytes. Am. J. Physiol. Heart Circ. Physiol 285, H2355–H2363 (2003). [PubMed: 14613910]   
22. Spach MS, Heidlage JF, Dolber PC & Barr RC Electrophysiological effects of remodeling cardiac gap junctions and cell size: experimental and model studies of normal cardiac growth. Circ. Res 86, 302–311 (2000). [PubMed: 10679482]   
23. Spach MS, Heidlage JF, Barr RC & Dolber PC Cell size and communication: role in structural and electrical development and remodeling of the heart. Heart Rhythm. 1, 500–515 (2004). [PubMed: 15851207]   
24. McCain ML & Parker KK Mechanotransduction: the role of mechanical stress, myocyte shape, and cytoskeletal architecture on cardiac function. Pflugers Arch. 462, 89–104 (2011). [PubMed: 21499986]   
25. Mummery C et al. Differentiation of human embryonic stem cells to cardiomyocytes: role of coculture with visceral endoderm-like cells. Circulation 107, 2733–2740 (2003). [PubMed: 12742992]   
26. Zhang J et al. Functional cardiomyocytes derived from human induced pluripotent stem cells. Circ. Res 104, e30–e41 (2009). [PubMed: 19213953]   
27. Liu J, Laksman Z & Backx PH The electrophysiological development of cardiomyocytes. Adv. Drug. Deliv. Rev 96, 253–273 (2016). [PubMed: 26788696]   
28. Carmeliet E Pacemaking in cardiac tissue. From IK2 to a coupled-clock system. Physiol. Rep 7, e13862 (2019). [PubMed: 30604930]   
29. Peinkofer G et al. From early embryonic to adult stage: comparative study of action potentials of native and pluripotent stem cell-derived cardiomyocytes. Stem Cell Dev. 25, 1397–1406 (2016).   
30. Koivumaki JT et al. Structural immaturity of human iPSC-derived cardiomyocytes: in silico investigation of effects on function and disease modeling. Front. Physiol 9, 80 (2018). [PubMed: 29467678]   
31. Veerman CC et al. Switch from fetal to adult SCN5A isoform in human induced pluripotent stem cell-derived cardiomyocytes unmasks the cellular phenotype of a conduction disease-causing mutation. J. Am. Heart Assoc. 6, e005135 (2017). [PubMed: 28739862]   
32. Buchanan JW Jr., Saito T & Gettes LS The effects of antiarrhythmic drugs, stimulation frequency, and potassium-induced resting membrane potential changes on conduction velocity and dV/dtmax in guinea pig myocardium. Circ. Res 56, 696–703 (1985). [PubMed: 3995697]   
33. Hoekstra M, Mummery CL, Wilde AA, Bezzina CR & Verkerk AO Induced pluripotent stem cell derived cardiomyocytes as models for cardiac arrhythmias. Front. Physiol 3, 346 (2012). [PubMed: 23015789]   
34. Zhao Z et al. Ion channel expression and characterization in human induced pluripotent stem cellderived cardiomyocytes. Stem Cell Int. 2018, 6067096 (2018).   
35. Doss MX et al. Maximum diastolic potential of human induced pluripotent stem cell-derived cardiomyocytes depends critically on I(Kr). PLoS One 7, e40288 (2012). [PubMed: 22815737]   
36. Moretti A et al. Patient-specific induced pluripotent stem-cell models for long-QT syndrome. N. Engl. J. Med 363, 1397–1409 (2010). [PubMed: 20660394]   
37. Ma J et al. High purity human-induced pluripotent stem cell-derived cardiomyocytes: electrophysiological properties of action potentials and ionic currents. Am. J. Physiol. Heart Circ. Physiol 301, H2006–H2017 (2011). [PubMed: 21890694]   
38. Zhang M et al. Recessive cardiac phenotypes in induced pluripotent stem cell models of Jervell and Lange-Nielsen syndrome: disease mechanisms and pharmacological rescue. Proc. Natl Acad. Sci. USA 111, E5383–E5392 (2014). [PubMed: 25453094]   
39. Sogo T et al. Electrophysiological properties of iPS cell-derived cardiomyocytes from a patient with long QT syndrome type 1 harboring the novel mutation M437V of KCNQ1. Regen. Ther 4, 9–17 (2016). [PubMed: 31245483]   
40. Zeng H, Wang J, Clouse H, Lagrutta A & Sannajust F Human-induced pluripotent stem cellderived cardiomyocytes have limited IKs for repolarization reserve as revealed by specific KCNQ1/KCNE1 blocker. JRSM Cardiovasc. Dis 8, 2048004019854919 (2019). [PubMed: 31217965]   
41. Cordeiro JM et al. Identification and characterization of a transient outward $\mathrm { K } +$ current in human induced pluripotent stem cell-derived cardiomyocytes. J. Mol. Cell Cardiol. 60, 36–46 (2013). [PubMed: 23542310]   
42. Scuderi GJ & Butcher J Naturally engineered maturation of cardiomyocytes. Front. Cell Dev. Biol 5, 50 (2017). [PubMed: 28529939]   
43. McDevitt TC et al. In vitro generation of differentiated cardiac myofibers on micropatterned laminin surfaces. J. Biomed. Mater. Res 60, 472–479 (2002). [PubMed: 11920672]   
44. Salameh A et al. Cyclic mechanical stretch induces cardiomyocyte orientation and polarization of the gap junction protein connexin43. Circ. Res 106, 1592–1602 (2010). [PubMed: 20378856]   
45. Zhang W et al. Maturation of human embryonic stem cell-derived cardiomyocytes (hESC-CMs) in 3D collagen matrix: effects of niche cell supplementation and mechanical stimulation. Acta Biomater. 49, 204–217 (2017). [PubMed: 27890729]   
46. Satin J et al. Calcium handling in human embryonic stem cell-derived cardiomyocytes. Stem Cell 26, 1961–1972 (2008).   
47. Lieu DK et al. Absence of transverse tubules contributes to non-uniform $\mathrm { C a } 2 +$ wavefronts in mouse and human embryonic stem cell-derived cardiomyocytes. Stem Cell Dev. 18, 1493–1500 (2009).   
48. Hwang HS et al. Comparable calcium handling of human iPSC-derived cardiomyocytes generated by multiple laboratories. J. Mol. Cell Cardiol. 85, 79–88 (2015). [PubMed: 25982839]   
49. Louch WE, Koivumaki JT & Tavi P Calcium signalling in developing cardiomyocytes: implications for model systems and disease. J. Physiol 593, 1047–1063 (2015). [PubMed: 25641733]   
50. Liu J et al. Facilitated maturation of $\mathrm { C a } 2 +$ handling properties of human embryonic stem cellderived cardiomyocytes by calsequestrin expression. Am. J. Physiol. Cell Physiol. 297, C152– C159 (2009). [PubMed: 19357236]   
51. Liu J, Fu JD, Siu CW & Li RA Functional sarcoplasmic reticulum for calcium handling of human embryonic stem cell-derived cardiomyocytes: insights for driven maturation. Stem Cell 25, 3038– 3044 (2007).   
52. Davis JP & Tikunova SB $\mathrm { C a } 2 +$ exchange with troponin C and cardiac muscle dynamics. Cardiovasc. Res 77, 619–626 (2008). [PubMed: 18079104]   
53. Kane C, Couch L & Terracciano CM Excitation-contraction coupling of human induced pluripotent stem cell-derived cardiomyocytes. Front. Cell Dev. Biol 3, 59 (2015). [PubMed: 26484342]   
54. Bird SD et al. The human adult cardiomyocyte phenotype. Cardiovasc. Res 58, 423–434 (2003). [PubMed: 12757876]   
55. Bedada FB et al. Acquisition of a quantitative, stoichiometrically conserved ratiometric marker of maturation status in stem cell-derived cardiac myocytes. Stem Cell Rep. 3, 594–605 (2014).   
56. Zuppinger C et al. Characterization of cytoskeleton features and maturation status of cultured human iPSC-derived cardiomyocytes. Eur. J. Histochem 61, 2763 (2017). [PubMed: 28735524]   
57. Iorga B et al. Differences in contractile function of myofibrils within human embryonic stem cellderived cardiomyocytes vs. adult ventricular myofibrils are related to distinct sarcomeric protein isoforms. Front. Physiol 8, 1111 (2017). [PubMed: 29403388]   
58. Hinson JT et al. Heart disease. Titin mutations in iPS cells define sarcomere insufficiency as a cause of dilated cardiomyopathy. Science 349, 982–986 (2015). [PubMed: 26315439]   
59. Mahdavi V, Lompre AM, Chambers AP & Nadal-Ginard B Cardiac myosin heavy chain isozymic transitions during development and under pathological conditions are regulated at the level of mRNA availability. Eur. Heart J. 5, 181–191 (1984). [PubMed: 6241892]   
60. Weber N et al. Stiff matrix induces switch to pure beta-cardiac myosin heavy chain expression in human ESC-derived cardiomyocytes. Basic. Res. Cardiol 111, 68 (2016). [PubMed: 27743117]   
61. Sabry MA & Dhoot GK Identification and pattern of expression of a developmental isoform of troponin I in chicken and rat cardiac muscle. J. Muscle Res. Cell Motil. 10, 85–91 (1989). [PubMed: 2708513]   
62. Gorza L, Ausoni S, Merciai N, Hastings KE & Schiaffino S Regional differences in troponin I isoform switching during rat heart development. Dev. Biol 156, 253–264 (1993). [PubMed: 8449370]   
63. Hunkeler NM, Kullman J & Murphy AM Troponin I isoform expression in human heart. Circ. Res 69, 1409–1414 (1991). [PubMed: 1934363]   
64. Sasse S et al. Troponin I gene expression during human cardiac development and in end-stage heart failure. Circ. Res 72, 932–938 (1993). [PubMed: 8477526]   
65. Metzger JM, Michele DE, Rust EM, Borton AR & Westfall MV Sarcomere thin filament regulatory isoforms. Evidence of a dominant effect of slow skeletal troponin I on cardiac contraction. J. Biol. Chem 278, 13118–13123 (2003). [PubMed: 12551900]   
66. Westfall MV, Rust EM & Metzger JM Slow skeletal troponin I gene transfer, expression, and myofilament incorporation enhances adult cardiac myocyte contractile function. Proc. Natl Acad. Sci. USA 94, 5444–5449 (1997). [PubMed: 9144257]   
67. Davis JP et al. Effects of thin and thick filament proteins on calcium binding and exchange with cardiac troponin C. Biophys. J 92, 3195–3206 (2007). [PubMed: 17293397]   
68. Chuva de Sousa Lopes SM et al. Patterning the heart, a template for human cardiomyocyte development. Dev. Dyn 235, 1994–2002 (2006). [PubMed: 16649168]   
69. Piccini I, Rao J, Seebohm G & Greber B Human pluripotent stem cell-derived cardiomyocytes: genome-wide expression profiling of long-term in vitro maturation in comparison to human heart tissue. Genom. Data 4, 69–72 (2015). [PubMed: 26484180]   
70. Clement S et al. Expression and function of alpha-smooth muscle actin during embryonic-stemcell-derived cardiomyocyte differentiation. J. Cell Sci. 120, 229–238 (2007). [PubMed: 17179203]   
71. Black FM et al. The vascular smooth muscle alpha-actin gene is reactivated during cardiac hypertrophy provoked by load. J. Clin. Invest 88, 1581–1588 (1991). [PubMed: 1834699]   
72. Suurmeijer AJ et al. Alpha-actin isoform distribution in normal and failing human heart: a morphological, morphometric, and biochemical study. J. Pathol 199, 387–397 (2003). [PubMed: 12579541]   
73. van Laake LW et al. Human embryonic stem cell-derived cardiomyocytes survive and mature in the mouse heart and transiently improve function after myocardial infarction. Stem Cell Res. 1, 9–24 (2007). [PubMed: 19383383]   
74. Kim HD Expression of intermediate filament desmin and vimentin in the human fetal heart. Anat. Rec 246, 271–278 (1996). [PubMed: 8888968]   
75. Werner JC, Sicard RE & Schuler HG Palmitate oxidation by isolated working fetal and newborn pig hearts. Am. J. Physiol 256, E315–E321 (1989). [PubMed: 2919670]   
76. Lopaschuk GD, Spafford MA & Marsh DR Glycolysis is predominant source of myocardial ATP production immediately after birth. Am. J. Physiol 261, H1698–H1705 (1991). [PubMed: 1750528]   
77. Stanley WC, Recchia FA & Lopaschuk GD Myocardial substrate metabolism in the normal and failing heart. Physiol. Rev 85, 1093–1129 (2005). [PubMed: 15987803]   
78. Galdos FX et al. Cardiac regeneration: lessons from development. Circ. Res 120, 941–959 (2017). [PubMed: 28302741]   
79. Palmer JW, Tandler B & Hoppel CL Biochemical properties of subsarcolemmal and interfibrillar mitochondria isolated from rat cardiac muscle. J. Biol. Chem 252, 8731–8739 (1977). [PubMed: 925018]   
80. Saks V et al. Intracellular energetic units regulate metabolism in cardiac cells. J. Mol. Cell Cardiol. 52, 419–436 (2012). [PubMed: 21816155]   
81. Hom JR et al. The permeability transition pore controls cardiac mitochondrial maturation and myocyte differentiation. Dev. Cell 21, 469–478 (2011). [PubMed: 21920313]   
82. Feric NT & Radisic M Maturing human pluripotent stem cell-derived cardiomyocytes in human engineered cardiac tissues. Adv. Drug. Deliv. Rev 96, 110–134 (2016). [PubMed: 25956564]   
83. Adler CP & Friedburg H Myocardial DNA content, ploidy level and cell number in geriatric hearts: post-mortem examinations of human myocardium in old age. J. Mol. Cell Cardiol. 18, 39–53 (1986). [PubMed: 3950970]   
84. Bergmann O et al. Evidence for cardiomyocyte renewal in humans. Science 324, 98–102 (2009). [PubMed: 19342590]   
85. Brodsky WY, Arefyeva AM & Uryvaeva IV Mitotic polyploidization of mouse heart myocytes during the first postnatal week. Cell Tissue Res. 210, 133–144 (1980). [PubMed: 7407859]   
86. Soonpaa MH, Kim KK, Pajak L, Franklin M & Field LJ Cardiomyocyte DNA synthesis and binucleation during murine development. Am. J. Physiol 271, H2183–H2189 (1996). [PubMed: 8945939]   
87. Puente BN et al. The oxygen-rich postnatal environment induces cardiomyocyte cell-cycle arrest through DNA damage response. Cell 157, 565–579 (2014). [PubMed: 24766806]   
88. Hirose K et al. Evidence for hormonal control of heart regenerative capacity during endothermy acquisition. Science 364, 184–188 (2019). [PubMed: 30846611]   
89. Herget GW, Neuburger M, Plagwitz R & Adler CP DNA content, ploidy level and number of nuclei in the human heart after myocardial infarction. Cardiovasc. Res 36, 45–51 (1997). [PubMed: 9415271]   
90. Adler CP Relationship between deoxyribonucleic acid content and nucleoli in human heart muscle cells and estimation of cell number during cardiac growth and hyperfunction. Recent. Adv. Stud. Card. Struct. Metab 8, 373–386 (1975).   
91. Patterson M et al. Frequency of mononuclear diploid cardiomyocytes underlies natural variation in heart regeneration. Nat. Genet 49, 1346–1353 (2017). [PubMed: 28783163]   
92. Gonzalez-Rosa JM et al. Myocardial polyploidization creates a barrier to heart regeneration in zebrafish. Dev. Cell 44, 433–446.e7 (2018). [PubMed: 29486195]   
93. Brooks G, Poolman RA, McGill CJ & Li JM Expression and activities of cyclins and cyclindependent kinases in developing rat ventricular myocytes. J. Mol. Cell. Cardiol 29, 2261–2271 (1997). [PubMed: 9281457]   
94. Kang MJ, Kim JS, Chae SW, Koh KN & Koh GY Cyclins and cyclin dependent kinases during cardiac development. Mol. Cells 7, 360–366 (1997). [PubMed: 9264023]   
95. Yoshizumi M et al. Disappearance of cyclin a correlates with permanent withdrawal of cardiomyocytes from the cell cycle in human and rat hearts. J. Clin. Invest 95, 2275–2280 (1995). [PubMed: 7738192]   
96. Koh KN et al. Persistent and heterogenous expression of the cyclin-dependent kinase inhibitor, p27KIP1, in rat hearts during development. J. Mol. Cell Cardiol. 30, 463–474 (1998). [PubMed: 9515024]   
97. Pasumarthi KB & Field LJ Cardiomyocyte cell cycle regulation. Circ. Res 90, 1044–1054 (2002). [PubMed: 12039793]   
98. Burton PB, Yacoub MH & Barton PJ Cyclin-dependent kinase inhibitor expression in human heart failure. A comparison with fetal development. Eur. Heart J. 20, 604–611 (1999). [PubMed: 10337545]   
99. Uosaki H et al. Transcriptional landscape of cardiomyocyte maturation. Cell Rep. 13, 1705–1716 (2015). [PubMed: 26586429]   
100. Shadrin IY et al. Cardiopatch platform enables maturation and scale-up of human pluripotent stem cell-derived engineered heart tissues. Nat. Commun 8, 1825 (2017). [PubMed: 29184059]   
101. Correia C et al. Distinct carbon sources affect structural and functional maturation of cardiomyocytes derived from human pluripotent stem cells. Sci. Rep 7, 8590 (2017). [PubMed: 28819274]   
102. Mohamed TMA et al. Regulation of cell cycle to stimulate adult cardiomyocyte proliferation and cardiac regeneration. Cell 173, 104–116.e12 (2018). [PubMed: 29502971]   
103. Yang X et al. Tri-iodo-L-thyronine promotes the maturation of human cardiomyocytes-derived from induced pluripotent stem cells. J. Mol. Cell Cardiol. 72, 296–304 (2014). [PubMed: 24735830]   
104. Diez-Cunado M et al. miRNAs that induce human cardiomyocyte proliferation converge on the hippo pathway. Cell Rep. 23, 2168–2174 (2018). [PubMed: 29768213]   
105. Zhou Q, Li L, Zhao B & Guan KL The hippo pathway in heart development, regeneration, and diseases. Circulation Res. 116, 1431–1447 (2015). [PubMed: 25858067]   
106. Mahmoud AI et al. Meis1 regulates postnatal cardiomyocyte cell cycle arrest. Nature 497, 249– 253 (2013). [PubMed: 23594737]   
107. Nakano H et al. Glucose inhibits cardiac muscle maturation through nucleotide biosynthesis. eLife 6, e29330 (2017). [PubMed: 29231167]   
108. Mills RJ et al. Functional screening in human cardiac organoids reveals a metabolic mechanism for cardiomyocyte cell cycle arrest. Proc. Natl Acad. Sci. USA 114, E8372–E8381 (2017). [PubMed: 28916735]   
109. Hassink RJ et al. Cardiomyocyte cell cycle activation improves cardiac function after myocardial infarction. Cardiovasc. Res 78, 18–25 (2008). [PubMed: 18079102]   
110. Zhu W, Zhao M, Mattapally S, Chen S & Zhang J CCND2 overexpression enhances the regenerative potency of human induced pluripotent stem cell-derived cardiomyocytes: remuscularization of injured ventricle. Circ. Res 122, 88–96 (2018). [PubMed: 29018036]   
111. Kamakura T et al. Ultrastructural maturation of human-induced pluripotent stem cell-derived cardiomyocytes in a long-term culture. Circ. J 77, 1307–1314 (2013). [PubMed: 23400258]   
112. Churko JM et al. Defining human cardiac transcription factor hierarchies using integrated singlecell heterogeneity analysis. Nat. Commun 9, 4906 (2018). [PubMed: 30464173]   
113. Friedman CE et al. Single-cell transcriptomic analysis of cardiac differentiation from human PSCs reveals HOPX-dependent cardiomyocyte maturation. Cell Stem Cell 23, 586–598.e8 (2018). [PubMed: 30290179]   
114. Kuppusamy KT et al. Let-7 family of microRNA is required for maturation and adult-like metabolism in stem cell-derived cardiomyocytes. Proc. Natl Acad. Sci. USA 112, E2785–E2794 (2015). [PubMed: 25964336]   
115. Kadota S, Pabon L, Reinecke H & Murry CE In vivo maturation of human induced pluripotent stem cell-derived cardiomyocytes in neonatal and adult rat hearts. Stem Cell Rep. 8, 278–289 (2017).   
116. Cho GS et al. Neonatal transplantation confers maturation of PSC-derived cardiomyocytes conducive to modeling cardiomyopathy. Cell Rep. 18, 571–582 (2017). [PubMed: 28076798]   
117. Funakoshi S et al. Enhanced engraftment, proliferation, and therapeutic potential in heart using optimized human iPSC-derived cardiomyocytes. Sci. Rep 6, 19111 (2016). [PubMed: 26743035]   
118. Laflamme MA et al. Formation of human myocardium in the rat heart from human embryonic stem cells. Am. J. Pathol 167, 663–671 (2005). [PubMed: 16127147]   
119. Chong JJ et al. Human embryonic-stem-cell-derived cardiomyocytes regenerate non-human primate hearts. Nature 510, 273–277 (2014). [PubMed: 24776797]   
120. Shiba Y et al. Allogeneic transplantation of iPS cell-derived cardiomyocytes regenerates primate hearts. Nature 538, 388–391 (2016). [PubMed: 27723741]   
121. Gerbin KA & Murry CE The winding road to regenerating the human heart. Cardiovasc. Pathol 24, 133–140 (2015). [PubMed: 25795463]   
122. Guo Y et al. Hierarchical and stage-specific regulation of murine cardiomyocyte maturation by serum response factor. Nat. Commun 9, 3837 (2018). [PubMed: 30242271]   
123. Ackers-Johnson M et al. A simplified, Langendorff-free method for concomitant isolation of viable cardiac myocytes and nonmyocytes from the adult mouse heart. Circ. Res 119, 909–920 (2016). [PubMed: 27502479]   
124. Banyasz T et al. Transformation of adult rat cardiac myocytes in primary culture. Exp. Physiol 93, 370–382 (2008). [PubMed: 18156167]   
125. Claycomb WC & Palazzo MC Culture of the terminally differentiated adult cardiac muscle cell: a light and scanning electron microscope study. Dev. Biol 80, 466–482 (1980). [PubMed: 7004954]   
126. Ribeiro AJ et al. Contractility of single cardiomyocytes differentiated from pluripotent stem cells depends on physiological shape and substrate stiffness. Proc. Natl Acad. Sci. USA 112, 12705– 12710 (2015). [PubMed: 26417073]   
127. Kim DH et al. Nanoscale cues regulate the structure and function of macroscopic cardiac tissue constructs. Proc. Natl Acad. Sci. USA 107, 565–570 (2010). [PubMed: 20018748]   
128. Macadangdang J et al. Nanopatterned human iPSC-based model of a dystrophin-null cardiomyopathic phenotype. Cell Mol. Bioeng 8, 320–332 (2015). [PubMed: 26366230]   
129. Rao C et al. The effect of microgrooved culture substrates on calcium cycling of cardiac myocytes derived from human induced pluripotent stem cells. Biomaterials 34, 2399–2411 (2013). [PubMed: 23261219]   
130. Werley CA et al. Geometry-dependent functional changes in iPSC-derived cardiomyocytes probed by functional imaging and RNA sequencing. PLoS One 12, e0172671 (2017). [PubMed: 28333933]   
131. Huethorst E et al. Enhanced human-induced pluripotent stem cell derived cardiomyocyte maturation using a dual microgradient substrate. ACS Biomater. Sci. Eng 2, 2231–2239 (2016). [PubMed: 27990488]   
132. Jacot JG et al. Cardiac myocyte force development during differentiation and maturation. Ann. NY Acad. Sci 1188, 121–127 (2010). [PubMed: 20201894]   
133. Martewicz S, Serena E, Zatti S, Keller G & Elvassore N Substrate and mechanotransduction influence SERCA2a localization in human pluripotent stem cell-derived cardiomyocytes affecting functional performance. Stem Cell Res. 25, 107–114 (2017). [PubMed: 29125993]   
134. Feaster TK et al. Matrigel mattress: a method for the generation of single contracting humaninduced pluripotent stem cell-derived cardiomyocytes. Circ. Res 117, 995–1000 (2015). [PubMed: 26429802]   
135. Herron TJ et al. Extracellular matrix-mediated maturation of human pluripotent stem cell-derived cardiac monolayer structure and electrophysiological function. Circ. Arrhythm. Electrophysiol 9, e003638 (2016). [PubMed: 27069088]   
136. Pinto AR et al. Revisiting cardiac cellular composition. Circ. Res 118, 400–409 (2016). [PubMed: 26635390]   
137. Ieda M et al. Cardiac fibroblasts regulate myocardial proliferation through beta1 integrin signaling. Dev. Cell 16, 233–244 (2009). [PubMed: 19217425]   
138. Bergmann O et al. Dynamics of cell generation and turnover in the human heart. Cell 161, 1566– 1575 (2015). [PubMed: 26073943]   
139. Tirziu D, Giordano FJ & Simons M Cell communications in the heart. Circulation 122, 928–937 (2010). [PubMed: 20805439]   
140. Fountoulaki K, Dagres N & Iliodromitis EK Cellular communications in the heart. Card. Fail. Rev 1, 64–68 (2015). [PubMed: 28785434]   
141. Brutsaert DL Cardiac endothelial-myocardial signaling: its role in cardiac growth, contractile performance, and rhythmicity. Physiol. Rev 83, 59–115 (2003). [PubMed: 12506127]   
142. Yu J et al. Topological arrangement of cardiac fibroblasts regulates cellular plasticity. Circ. Res 123, 73–85 (2018). [PubMed: 29691232]   
143. Herum KM, Choppe J, Kumar A, Engler AJ & McCulloch AD Mechanical regulation of cardiac fibroblast profibrotic phenotypes. Mol. Biol. Cell 28, 1871–1882 (2017). [PubMed: 28468977]   
144. Lee DS et al. Defined microRNAs induce aspects of maturation in mouse and human embryonicstem-cell-derived cardiomyocytes. Cell Rep. 12, 1960–1967 (2015). [PubMed: 26365191]   
145. Dunn KK et al. Coculture of endothelial cells with human pluripotent stem cell-derived cardiac progenitors reveals a differentiation stage-specific enhancement of cardiomyocyte maturation. Biotechnol. J 14, e1800725 (2019). [PubMed: 30927511]   
146. Zuppinger C 3D culture for cardiac cells. Biochim. Biophys. Acta 1863, 1873–1881 (2016). [PubMed: 26658163]   
147. Hirt MN, Hansen A & Eschenhagen T Cardiac tissue engineering: state of the art. Circ. Res 114, 354–367 (2014). [PubMed: 24436431]   
148. Ronaldson-Bouchard K et al. Advanced maturation of human cardiac tissue grown from pluripotent stem cells. Nature 556, 239–243 (2018). [PubMed: 29618819]   
149. Ulmer BM et al. Contractile work contributes to maturation of energy metabolism in hiPSCderived cardiomyocytes. Stem Cell Rep. 10, 834–847 (2018).   
150. Mannhardt I et al. Human engineered heart tissue: analysis of contractile force. Stem Cell Rep. 7, 29–42 (2016).   
151. Lemoine MD et al. Human iPSC-derived cardiomyocytes cultured in 3D engineered heart tissue show physiological upstroke velocity and sodium current density. Sci. Rep 7, 5464 (2017). [PubMed: 28710467]   
152. Zhang D et al. Tissue-engineered cardiac patch for advanced functional maturation of human ESC-derived cardiomyocytes. Biomaterials 34, 5813–5820 (2013). [PubMed: 23642535]   
153. Schaaf S et al. Human engineered heart tissue as a versatile tool in basic research and preclinical toxicology. PLoS One 6, e26397 (2011). [PubMed: 22028871]   
154. Tiburcy M et al. Defined engineered human myocardium with advanced maturation for applications in heart failure modeling and repair. Circulation 135, 1832–1847 (2017). [PubMed: 28167635]   
155. Bargehr J et al. Epicardial cells derived from human embryonic stem cells augment cardiomyocyte-driven heart regeneration. Nat. Biotechnol 37, 895–906 (2019). [PubMed: 31375810]   
156. Ravenscroft SM, Pointon A, Williams AW, Cross MJ & Sidaway JE Cardiac non-myocyte cells show enhanced pharmacological function suggestive of contractile maturity in stem cell derived cardiomyocyte microtissues. Toxicol. Sci 152, 99–112 (2016). [PubMed: 27125969]   
157. Giacomelli E et al. Three-dimensional cardiac microtissues composed of cardiomyocytes and endothelial cells co-differentiated from human pluripotent stem cells. Development 144, 1008– 1017 (2017). [PubMed: 28279973]   
158. Lindsey SE, Butcher JT & Yalcin HC Mechanical regulation of cardiac development. Front. Physiol 5, 318 (2014). [PubMed: 25191277]   
159. Ruwhof C & van der Laarse A Mechanical stress-induced cardiac hypertrophy: mechanisms and signal transduction pathways. Cardiovasc. Res 47, 23–37 (2000). [PubMed: 10869527]   
160. Judd J, Lovas J & Huang GN Isolation, culture and transduction of adult mouse cardiomyocytes. J. Vis. Exp 87, 54012 (2016).   
161. Zimmermann WH et al. Tissue engineering of a differentiated cardiac muscle construct. Circ. Res 90, 223–230 (2002). [PubMed: 11834716]   
162. Tulloch NL et al. Growth of engineered human myocardium with mechanical loading and vascular coculture. Circ. Res 109, 47–59 (2011). [PubMed: 21597009]   
163. Ruan JL et al. Mechanical stress conditioning and electrical stimulation promote contractility and force maturation of induced pluripotent stem cell-derived human cardiac tissue. Circulation 134, 1557–1567 (2016). [PubMed: 27737958]   
164. Wiegerinck RF et al. Force frequency relationship of the human ventricle increases during early postnatal development. Pediatr. Res 65, 414–419 (2009). [PubMed: 19127223]   
165. Leonard A et al. Afterload promotes maturation of human induced pluripotent stem cell derived cardiomyocytes in engineered heart tissues. J. Mol. Cell Cardiol. 118, 147–158 (2018). [PubMed: 29604261]   
166. Radisic M et al. Functional assembly of engineered myocardium by electrical stimulation of cardiac myocytes cultured on scaffolds. Proc. Natl. Acad. Sci. USA 101, 18129–18134 (2004). [PubMed: 15604141]   
167. Godier-Furnemont AF et al. Physiologic force-frequency response in engineered heart muscle by electromechanical stimulation. Biomaterials 60, 82–91 (2015). [PubMed: 25985155]   
168. Nunes SS et al. Biowire: a platform for maturation of human pluripotent stem cell-derived cardiomyocytes. Nat. Methods 10, 781–787 (2013). [PubMed: 23793239]   
169. Zhao Y et al. A platform for generation of chamber-specific cardiac tissues and disease modeling. Cell 176, 913–927.e18 (2019). [PubMed: 30686581]   
170. Eng G et al. Autonomous beating rate adaptation in human stem cell-derived cardiomyocytes. Nat. Commun 7, 10312 (2016). [PubMed: 26785135]   
171. Hasenfuss G et al. Energetics of isometric force development in control and volume-overload human myocardium. Comparison with animal species. Circ. Res 68, 836–846 (1991). [PubMed: 1742869]   
172. Ronaldson-Bouchard K et al. Author correction: advanced maturation of human cardiac tissue grown from pluripotent stem cells. Nature 572, E16–E17 (2019). [PubMed: 31363231]   
173. Li M et al. Thyroid hormone action in postnatal heart development. Stem Cell Res. 13, 582–591 (2014). [PubMed: 25087894]   
174. Rog-Zielinska EA et al. Glucocorticoids promote structural and functional maturation of foetal cardiomyocytes: a role for PGC-1α. Cell Death Differ. 22, 1106–1116 (2015). [PubMed: 25361084]   
175. Rog-Zielinska EA et al. Glucocorticoid receptor is required for foetal heart maturation. Hum. Mol. Genet 22, 3269–3282 (2013). [PubMed: 23595884]   
176. Birket MJ et al. PGC-1alpha and reactive oxygen species regulate human embryonic stem cellderived cardiomyocyte function. Stem Cell Rep. 1, 560–574 (2013).   
177. Parikh SS et al. Thyroid and glucocorticoid hormones promote functional T-tubule development in human-induced pluripotent stem cell-derived cardiomyocytes. Circ. Res 121, 1323–1330 (2017). [PubMed: 28974554]   
178. Foldes G et al. Modulation of human embryonic stem cell-derived cardiomyocyte growth: a testbed for studying human cardiac hypertrophy? J. Mol. Cell Cardiol. 50, 367–376 (2011). [PubMed: 21047517]   
179. Wu L et al. Angiotensin II promotes cardiac differentiation of embryonic stem cells via angiotensin type 1 receptor. Differentiation 86, 23–29 (2013). [PubMed: 23933399]   
180. Nakamura M & Sadoshima J Mechanisms of physiological and pathological cardiac hypertrophy. Nat. Rev. Cardiol 15, 387–407 (2018). [PubMed: 29674714]   
181. Troncoso R, Ibarra C, Vicencio JM, Jaimovich E & Lavandero S New insights into IGF-1 signaling in the heart. Trends Endocrinol. Metab 25, 128–137 (2014). [PubMed: 24380833]   
182. McDevitt TC, Laflamme MA & Murry CE Proliferation of cardiomyocytes derived from human embryonic stem cells is mediated via the IGF/PI 3-kinase/Akt signaling pathway. J. Mol. Cell Cardiol. 39, 865–873 (2005). [PubMed: 16242146]   
183. Meyer D & Birchmeier C Multiple essential functions of neuregulin in development. Nature 378, 386–390 (1995). [PubMed: 7477375]   
184. Lee KF et al. Requirement for neuregulin receptor erbB2 in neural and cardiac development. Nature 378, 394–398 (1995). [PubMed: 7477377]   
185. Gassmann M et al. Aberrant neural and cardiac development in mice lacking the ErbB4 neuregulin receptor. Nature 378, 390–394 (1995). [PubMed: 7477376]   
186. Rupert CE & Coulombe KLK IGF1 and NRG1 enhance proliferation, metabolic maturity, and the force-frequency response in hESC-derived engineered cardiac tissues. Stem Cell Int. 2017, 7648409 (2017).   
187. Yang X et al. Fatty acids enhance the maturation of cardiomyocytes derived from human pluripotent stem cells. Stem Cell Rep. 13, 657–668 (2019).   
188. Courtnay R et al. Cancer metabolism and the Warburg effect: the role of HIF-1 and PI3K. Mol. Biol. Rep 42, 841–851 (2015). [PubMed: 25689954]   
189. Kim JW, Tchernyshyov I, Semenza GL & Dang CV HIF-1-mediated expression of pyruvate dehydrogenase kinase: a metabolic switch required for cellular adaptation to hypoxia. Cell Metab. 3, 177–185 (2006). [PubMed: 16517405]   
190. Semenza GL et al. Hypoxia response elements in the aldolase A, enolase 1, and lactate dehydrogenase A gene promoters contain essential binding sites for hypoxia-inducible factor 1. J. Biol. Chem 271, 32529–32537 (1996). [PubMed: 8955077]   
191. Hu D et al. Metabolic maturation of human pluripotent stem cell-derived cardiomyocytes by inhibition of HIF1alpha and LDHA. Circ. Res 123, 1066–1079 (2018). [PubMed: 30355156]   
192. Menendez-Montes I et al. Myocardial VHL-HIF signaling controls an embryonic metabolic switch essential for cardiac maturation. Dev. Cell 39, 724–739 (2016). [PubMed: 27997827]   
193. van den Berg CW et al. Transcriptome of human foetal heart compared with cardiomyocytes from pluripotent stem cells. Development 142, 3231–3238 (2015). [PubMed: 26209647]   
194. Fu JD et al. Distinct roles of microRNA-1 and −499 in ventricular specification and functional maturation of human embryonic stem cell-derived cardiomyocytes. PLoS One 6, e27417 (2011). [PubMed: 22110643]   
195. Miklas JW et al. TFPa/HADHA is required for fatty acid beta-oxidation and cardiolipin remodeling in human cardiomyocytes. Nat. Commun 10, 4671 (2019). [PubMed: 31604922]   
196. Poon EN et al. Integrated transcriptomic and regulatory network analyses identify microRNA-200c as a novel repressor of human pluripotent stem cell-derived cardiomyocyte differentiation and maturation. Cardiovasc. Res 114, 894–906 (2018). [PubMed: 29373717]   
197. Yang B et al. The muscle-specific microRNA miR-1 regulates cardiac arrhythmogenic potential by targeting GJA1 and KCNJ2. Nat. Med 13, 486–491 (2007). [PubMed: 17401374]   
198. Chow MZ et al. Epigenetic regulation of the electrophysiological phenotype of human embryonic stem cell-derived ventricular cardiomyocytes: insights for driven maturation and hypertrophic growth. Stem Cell Dev. 22, 2678–2690 (2013).   
199. Poon E et al. Proteomic analysis of human pluripotent stem cell-derived, fetal, and adult ventricular cardiomyocytes reveals pathways crucial for cardiac metabolism and maturation. Circ. Cardiovasc. Genet 8, 427–436 (2015). [PubMed: 25759434]   
200. Hellen N et al. Proteomic analysis reveals temporal changes in protein expression in human induced pluripotent stem cell-derived cardiomyocytes in vitro. Stem Cell Dev. 28, 565–578 (2019).   
201. Bhute VJ et al. Metabolomics identifies metabolic markers of maturation in human pluripotent stem cell-derived cardiomyocytes. Theranostics 7, 2078–2091 (2017). [PubMed: 28656061]   
202. Correia C et al. 3D aggregate culture improves metabolic maturation of human pluripotent stem cell derived cardiomyocytes. Biotechnol. Bioeng 115, 630–644 (2018). [PubMed: 29178315]   
203. Palpant NJ et al. Generating high-purity cardiac and endothelial derivatives from patterned mesoderm using human pluripotent stem cells. Nat. Protoc 12, 15–31 (2017). [PubMed: 27906170]   
204. Lian X et al. Directed cardiomyocyte differentiation from human pluripotent stem cells by modulating Wnt/beta-catenin signaling under fully defined conditions. Nat. Protoc 8, 162–175 (2013). [PubMed: 23257984]   
205. Chen VC et al. Development of a scalable suspension culture for cardiac differentiation from human pluripotent stem cells. Stem Cell Res. 15, 365–375 (2015). [PubMed: 26318718]   
206. Jackman C, Li H & Bursac N Long-term contractile activity and thyroid hormone supplementation produce engineered rat myocardium with adult-like structure and function. Acta Biomater. 78, 98–110 (2018). [PubMed: 30086384]   
207. Reinecke H, Zhang M, Bartosek T & Murry CE Survival, integration, and differentiation of cardiomyocyte grafts: a study in normal and injured rat hearts. Circulation 100, 193–202 (1999). [PubMed: 10402450]   
208. Nakamura K & Murry CE Function follows form — a review of cardiac cell therapy. Circ. J 83, 2399–2412 (2019). [PubMed: 31723070]   
209. Sylva M, van den Hoff MJ & Moorman AF Development of the human heart. Am. J. Med. Genet. A 164A, 1347–1371 (2014). [PubMed: 23633400]   
210. Rochais F, Mesbah K & Kelly RG Signaling pathways controlling second heart field development. Circ. Res 104, 933–942 (2009). [PubMed: 19390062]   
211. Manner J The anatomy of cardiac looping: a step towards the understanding of the morphogenesis of several forms of congenital cardiac malformations. Clin. Anat 22, 21–35 (2009). [PubMed: 18661581]   
212. Kelly RG, Buckingham ME & Moorman AF Heart fields and cardiac morphogenesis. Cold Spring Harb. Perspect. Med 4, a015750 (2014). [PubMed: 25274757]   
213. Del Monte-Nieto G et al. Control of cardiac jelly dynamics by NOTCH1 and NRG1 defines the building plan for trabeculation. Nature 557, 439–445 (2018). [PubMed: 29743679]   
214. Zhang W, Chen H, Qu X, Chang CP & Shou W Molecular mechanism of ventricular trabeculation/compaction and the pathogenesis of the left ventricular noncompaction cardiomyopathy (LVNC). Am. J. Med. Genet. C. Semin. Med. Genet 163C, 144–156 (2013). [PubMed: 23843320]   
215. Lunkenheimer PP et al. Three-dimensional architecture of the left ventricular myocardium. Anat. Rec. A Discov. Mol. Cell Evol. Biol 288, 565–578 (2006). [PubMed: 16705738]   
216. Sosnovik DE & Geva T Imaging the microstructure of the human fetal heart. Circ. Cardiovasc. Imaging 11, e008298 (2018). [PubMed: 30354486]   
217. MacGrogan D, Munch J & de la Pompa JL Notch and interacting signalling pathways in cardiac development, disease, and regeneration. Nat. Rev. Cardiol 15, 685–704 (2018). [PubMed: 30287945]   
218. Paige SL, Plonowska K, Xu A & Wu SM Molecular regulation of cardiomyocyte differentiation. Circ. Res 116, 341–353 (2015). [PubMed: 25593278]   
219. Stankunas K et al. Endocardial Brg1 represses ADAMTS1 to maintain the microenvironment for myocardial morphogenesis. Dev. Cell 14, 298–311 (2008). [PubMed: 18267097]   
220. Sedmera D & Thompson RP Myocyte proliferation in the developing heart. Dev. Dyn 240, 1322– 1334 (2011). [PubMed: 21538685]   
221. Olivetti G et al. Aging, cardiac hypertrophy and ischemic cardiomyopathy do not affect the proportion of mononucleated and multinucleated myocytes in the human heart. J. Mol. Cell Cardiol. 28, 1463–1477 (1996). [PubMed: 8841934]   
222. Poindexter BJ, Smith JR, Buja LM & Bick RJ Calcium signaling mechanisms in dedifferentiated cardiac myocytes: comparison with neonatal and adult cardiomyocytes. Cell Calcium 30, 373– 382 (2001). [PubMed: 11728132]   
223. Horackova M & Byczko Z Differences in the structural characteristics of adult guinea pig and rat cardiomyocytes during their adaptation and maintenance in long-term cultures: confocal microscopy study. Exp. Cell Res. 237, 158–175 (1997). [PubMed: 9417879]   
224. Mitcheson JS, Hancox JC & Levi AJ Cultured adult cardiac myocytes: future applications, culture methods, morphological and electrophysiological properties. Cardiovasc. Res 39, 280–300 (1998). [PubMed: 9798514]   
225. Janssen PM, Lehnart SE, Prestle J & Hasenfuss G Preservation of contractile characteristics of human myocardium in multi-day cell culture. J. Mol. Cell. Cardiol 31, 1419–1427 (1999). [PubMed: 10423340]   
226. Qiao Y et al. Multiparametric slice culture platform for the investigation of human cardiac tissue physiology. Prog. Biophy. Mol. Biol 144, 139–150 (2018).   
227. Brandenburger M et al. Organotypic slice culture from human adult ventricular myocardium. Cardiovasc. Res 93, 50–59 (2012). [PubMed: 21972180]   
228. Watson SA et al. Preparation of viable adult ventricular myocardial slices from large and small mammals. Nat. Protoc 12, 2623–2639 (2017). [PubMed: 29189769]   
229. Ou Q et al. Physiological biomimetic culture system for pig and human heart slices. Circ. Res 125, 628–642 (2019). [PubMed: 31310161]   
230. Leone M, Musa G & Engel FB Cardiomyocyte binucleation is associated with aberrant mitotic microtubule distribution, mislocalization of RhoA and IQGAP3, as well as defective actomyosin ring anchorage and cleavage furrow ingression. Cardiovasc. Res 114, 1115–1131 (2018). [PubMed: 29522098]   
231. Engel FB Cardiomyocyte proliferation: a platform for mammalian cardiac repair. Cell Cycle 4, 1360–1363 (2005). [PubMed: 16138008]   
232. Hesse M et al. Midbody positioning and distance between daughter nuclei enable unequivocal identification of cardiomyocyte cell division in mice. Circ. Res 123, 1039–1052 (2018). [PubMed: 30355161]   
233. Chopra A et al. Force generation via $\beta$ -cardiac myosin, titin, and α-actinin drives cardiac sarcomere assembly from cell-matrix adhesions. Developmental Cell 44, 87–96.e5 (2018). [PubMed: 29316444]   
234. Fenix AM et al. Muscle-specific stress fibers give rise to sarcomeres in cardiomyocytes. eLife 7, e42144 (2018). [PubMed: 30540249]   
235. Ueno S et al. Biphasic role for Wnt/beta-catenin signaling in cardiac specification in zebrafish and embryonic stem cells. Proc. Natl Acad. Sci. USA 104, 9685–9690 (2007). [PubMed: 17522258]   
236. Murry CE & Keller G Differentiation of embryonic stem cells to clinically relevant populations: lessons from embryonic development. Cell 132, 661–680 (2008). [PubMed: 18295582]   
237. Horvath A et al. Low resting membrane potential and low inward rectifier potassium currents are not inherent features of hiPSC-derived cardiomyocytes. Stem Cell Rep. 10, 822–833 (2018).

# Key points

Cardiomyocytes can be generated in vitro from stem cells with high   
throughput and purity at a clinically relevant scale, although their   
differentiation status resembles an embryonic state.   
Cardiomyocyte maturation entails adoption of multiple complex phenotypes, and a number of methods to mature stem cell-derived cardiomyocytes have been successful in driving the cells towards a postnatal state.   
Stem cell-derived cardiomyocyte phenotypes have been characterized with the use of global systems approaches, which has uncovered novel regulators and insights for maturation.   
Moving forward, strategies for cardiomyocyte maturation will require   
indication-specific optimization for intended applications of stem cell-derived cardiomyocytes, leveraging an optimal maturation state while utilizing combinatorial approaches.

# Pluripotent stem cells

Stem cells with the capacity to differentiate into any cell type of the embryo. This term encompasses embryonic stem cells and induced pluripotent stem cells.

# Embryonic stages

In humans, the first trimester of in utero development.

# Fetal stages

In humans, the second and third trimesters of in utero development.

# Immature cardiomyocytes

Underdeveloped cardiomyocytes that lack the characteristics of adult cardiomyocytes.

# Polyploidy

The state in which cells or organisms have more than two complete sets of chromosomes.

# Membrane capacitance

Ratio of electric charge to membrane potential that is directly proportional to the cell surface area.

# Mature cardiomyocytes

Cardiomyocytes that are fully developed and resemble in vivo adult cells in structure and function.

# Compliant

The capacity to stretch or otherwise deform in response to a change in tension, mathematically defined as the change in length (strain) divided by the change in force (stress).

# Tension

Force transmitted axially during contraction or relaxation.

# microRNAs

(miRNas). Small non-coding RNas ${ \sim } 2 0$ nucleotides) that downregulate protein levels through post-transcriptional regulation of mRNa.

# Human induced pluripotent stem cell

(hiPSC). Stem cell generated by reprogramming a terminally differentiated, somatic cell to a pluripotent state.

# Allogeneic

Genetically distinct but from the same species.

# Elastic modulus

The stiffness of a material, mathematically defined as the change in stress divided by the change in strain (that is, the reciprocal of compliant).

# Matrigel

A commercially available extracellular matrix secreted by mouse sarcoma cells.

# Collagen

The principal fibrillar extracellular matrix protein in the heart.

# Fibrin

A blood protein that self-assembles into a nanofiber meshwork; its natural function is in blood coagulation, but it has been repurposed for tissue engineering scaffolds.

# Isometric contractile force

A contraction in which tension increases without changes in muscle length.

# Frank–Starling relationship

The property of heart muscle whereby an increase in resting tension (preload) linearly increases the strength of contraction.

# Force–frequency relationship

The property of mature heart muscle in which increasing frequency of stimulation results in greater force generation.

# Afterload

Tension on cardiomyocytes experienced during systole, typically provided by blood pressure.

# Auxotonic contraction

A form of contraction in which the muscle shortens against a changing tension.

# Diad

Structure in the cardiomyocyte located at the sarcomere $\boldsymbol { \mathrm { Z } }$ line, formed by a T-tubule paired with a terminal cisterna of the sarcoplasmic reticulum.

# Conduction velocity

The speed of propagation of an action potential across a cell or multicellular tissue.

# Box 1 |

# Developmental maturation of cardiomyocytes

The heart is one of the first organs of the human body to develop and function. Cells from the first heart field migrate and fuse at the midline, generating the primordial heart tube by embryonic day 20 (E20)209. Cells from the second heart field slowly integrate into the developing heart at both the arterial and the venous pole210. In humans, from E22 to E23 the heart tube forms a helically wound structure in a process called cardiac looping211. Cardiac looping is essential for establishing the left–right asymmetry of the future ventricle chambers and is also the first lateral asymmetry in the embryo212. During this process, the formation of trabecular ridges within the ventricular wall promotes nutrient exchange and enhances contractile force generation212–214. In the late stage of embryonic development with the formation of the four-chamber heart (E56), the trabeculae collapse towards the myocardial wall creating a thick, compact structure215,216. The late gestational stages are poorly studied in humans and most of the knowledge comes from animal studies. In mice, endocardial expression of neuregulin 1 (NRG1) and Notch signals such as Delta-like protein 4 regulate trabeculation and compaction of the myocardium217 (see the figure). Indeed, these signals act antagonistically to establish trabecular architecture: NRG1 binds to the tyrosine-protein kinase receptors ERBB2 and ERBB4 to promote trabeculae expansion by promoting extracellular matrix (ECM) synthesis; NOTCH1, whose expression is restricted to the base of trabeculae by vascular endothelial growth factor A (VEGFA), increases both proliferation of trabecular cardiomyocytes and ECM degradation by upregulation of myocardial bone morphogenetic protein 10 (BMP10) via $\mathrm { p } 5 7 ^ { \mathrm { K i p } 2 }$ inhibition and endocardial expression of a disintegrin and metalloproteinase with thrombospondin type 1 motif 1 (ADAMTS1), respectively213,218,219. The expression of Daam1, Vangl2 and Scrib, which are downstream signals of the noncanonical Wnt pathway in trabecular myocardium, regulates cardiomyocyte polarization and myofibrillogenesis214. Cardiomyocytes of the trabeculae are more elongated and have less mitotic activity than the cardiomyocytes of the compact myocardium220.

During early postnatal stages in humans, cardiomyocytes can proliferate, whereas cardiomyocyte hypertrophy typifies the adult stage when most of the cardiomyocytes are mononucleated, tetraploid and have increased size compared with fetal cardiomyocytes83,221. In the postnatal stage, the myocardial wall further matures in a multilayered, spirally organized muscle. This maturation is reflected in the cardiac output increase from $1 2 0 \mathrm { m l / m i n }$ in late gestation to $1 { , } 7 0 0 \mathrm { m l / m i n }$ in the neonatal stage and $\sim 5 , 0 0 0 \mathrm { m l / m i n }$ in adults42.

![](images/f715f3d07e95dbb45bc3fb8486ec45694111ac11b51d0d029679317470b606f6.jpg)

BRG1, transcription activator BRG1; FGF, fibroblast growth factor; MEF2C, myocyte enhancer factor 2C; NKX2.5, NK2 homeobox 5; TBX20, T-box transcription factor TBX20.

Box 2 |

# Cardiomyocyte dedifferentiation and harnessing immaturity

The observed immaturity of pluripotent stem cell-derived cardiomyocytes (PSC-CMs) suggests that using cardiomyocytes isolated from adult sources (such as from humans or rats) might facilitate the generation of more physiologically relevant data. Indeed, adult tissue has been, and continues to be, a source for in vitro studies, although its use also presents serious challenges. In standard in vitro culture conditions, isolated adult primary cardiomyocytes either die or rapidly lose their mature phenotype124,125,222–224. This dedifferentiation leads to loss of electrophysiological properties (which includes a gain of automaticity), reduced contractile function and loss of adult-like structure (including loss of T-tubules within hours). Therefore, physiologically relevant studies must be conducted shortly after cell isolation. These limitations demonstrate the fundamental importance of the in vivo environment for maintaining the mature cardiac phenotype and highlight the shortcomings of standard cell culture techniques. Furthermore, these limitations have led to a re-exploration of the use of human adult heart tissue slices in long-term culture, which demonstrate impressive maintenance of structure and function and show promise for disease modelling and for toxicology and drug screening225–229. However, these models are currently limited by their fairly low throughput, the technical expertise required, and the inability to control for genetic diversity between individuals or perform and trace the developmental consequences of perturbations (for example, genome editing) compared with PSC-CMs. Conversely, heart tissue slices have an added benefit of being directly isolated from the patient without requiring additional reprogramming steps.

Although the immaturity of PSC-CMs hinders their applications, many lessons can be learned from these cells. For example, rat neonatal cardiomyocytes, although immature, have provided a wealth of information on the mechanisms of cell cycle withdrawal and binucleation230–232. These studies would be much more difficult in adult cardiomyocytes, which have extremely low levels of cell division. Human PSC-CMs (hPSC-CMs) could prove similarly powerful for studying the initial steps of sarcomere assembly in humans233,234. Future studies could harness the current immaturity of hPSC-CMs to study processes or events that happen during development or during the early stages of maturation (such as the prenatal-to-postnatal transition). Indeed, ‘basic’ developmental biology studies have facilitated the understanding of the signalling pathways required for cardiac differentiation and our capacity to differentiate cardiomyocytes from stem cells235,236. Similarly, studying the biology of immature hPSC-CMs could facilitate a greater understanding of the requirements for maturation. In addition, some properties of immature cardiomyocytes might be desirable for some applications. For example, our group has demonstrated that fetal and neonatal but not adult cardiomyocytes can engraft in normal and injured myocardium in animal models207. However, the immature electrical characteristics of PSC-CMs are thought to contribute to the observed arrhythmias in non-human primates after PSC-CM transplantation1. Therefore, a combination of the resilience and engraftment capacity of immature cells with the

stability and function of mature cardiomyocytes might produce the best results for heart regeneration applications.

![](images/2654e16cbf6db1db4f8b6b0e18e9689dd019ac99fec5fa578ca495034173e28d.jpg)  
Fig. 1 |. Cardiomyocyte maturation features.

a | Cardiomyocytes undergo dynamic changes structurally and functionally during the course of maturation in vivo. The features of human pluripotent stem cell-derived cardiomyocytes and the sought-after maturation features of adult-like cardiomyocytes are illustrated in parts b–g. b | Cardiomyocytes undergo an increase in size and become anisotropic, organizing their contractile cytoskeleton and remodelling nuclei, junctions and other organelles, as described below. c | As cardiomyocytes mature, their action potentials change dramatically, including loss of automaticity, acquiring a more negative resting membrane potential (approximately $- 9 0 \mathrm { m V }$ ), and increases in action potential duration and amplitude. At the tissue level, immature cardiomyocytes have circumferentially distributed gap junctions and, during maturation, the junctions become polarized to intercalated discs at the cell ends, resulting in faster electrical conduction. d | Improved calcium handling in mature cardiomyocytes is mediated by the increased volume and calcium stores of the sarcoplasmic reticulum, the development of T-tubules and the expression and synchrony of calciumhandling proteins for the establishment of excitation–contraction coupling. e | Increases in contractile force with maturation are due to increases in myofibril content, improved alignment of myofibrils with registration of their sarcomeres and the switch in the expression of myofibril protein isoforms. f | Metabolic maturation entails the switch to fatty acid utilization, concurrent with increases in mitochondria number and the expression of the machinery for $\beta$ -oxidation $( \beta \mathrm { - O x } )$ and oxidative phosphorylation. g | Immature cardiomyocytes have proliferation potential whereas more mature cells principally undergo hypertrophy (increase in volume) with increasing load. Mature human cardiomyocytes have more DNA content per nucleus than immature cells, whereas rodent cardiomyocytes have increased nuclei number. CPT, carnitine O-palmitoyltransferase; FA-CoA, fatty acyl-CoA ester; mtDNA, mitochondrial DNA; n, haploid content of chromosomes; NCX, sodium– calcium exchanger; RYR2, ryanodine receptor 2; SERCA2a, sarcoplasmic/endoplasmic reticulum calcium ATPase 2a.

![](images/c78448ddc0b231944524914adf38d8d36cb19bfb60f98b0c8a59030be0c2e021.jpg)  
b Human primary adult cardiomyocyte   
Fig. 2 |. Cardiomyocyte electrophysiology.

Action potential recordings from a human pluripotent stem cell (hPSC)-derived cardiomyocyte (part a) and an isolated human primary left ventricular cardiomyocyte (part b). The major ion currents involved in establishing the phases of the cardiomyocyte action potential and the corresponding genes and channels are shown below the tracings. The action potentials were recorded by patch clamp and, given the variability in patch clamp preparation, the magnitude and the duration of the different currents are approximate33,34. Both tracings are on the same timescale. $\mathrm { C a } _ { \mathrm { v } } 1 . 2$ , voltage-dependent L-type calcium channel; $\operatorname { C a } _ { \mathrm { v } } 3 . 2$ , voltage-dependent T-type calcium channel; HCN4, hyperpolarization-activated cyclic nucleotide-gated channel 4; hERG, human Ether- $\mathbf { \hat { a } } \mathbf { \cdot } \mathbf { }$ -go-go-related gene (also known as ${ \mathrm { K } } _ { \mathrm { v } } 1 1 . 1 )$ ; $I _ { \mathrm { C a L } }$ , L-type calcium channel current; ${ \cal I } _ { \mathrm { C a T } }$ , T-type calcium channel current; If, pacemaker or funny current; $I _ { \mathrm { K 1 } }$ , inward-rectifier potassium current; $I _ { \mathrm { K r } }$ , rapid delayedrectifier potassium current; $I _ { \mathrm { K s } }$ , slow delayed-rectifier potassium current; $I _ { \mathrm { N a } }$ , sodium current; $I _ { \mathrm { t o } }$ , transient outward potassium current; $\mathrm { K } _ { \mathrm { i r } } 2 . 1$ , inward-rectifier potassium channel; $\mathrm { K } _ { \mathrm { v } } 4 . 3$ , voltage-gated potassium channel; KvLQT1 or $\mathrm { K } _ { \mathrm { v } } 7 . 1$ , potassium channel; $\mathrm { N a } _ { \mathrm { v } } 1 . 5$ , sodium channel; $\mathrm { { \tt p A } } / \mathrm { { \tt p F } } ,$ picoampere per picofarad. Part a tracing courtesy of C. E. Murry and X. Yang. Part $\mathbf { b }$ tracing is reprinted from ReF.237, CC BY 4.0 (https:// creativecommons.org/licenses/by/4.0).

![](images/25fc772e1a82d94f4b08c40bf9d625646e6af1faa8785db8a625eefe7f4fbe16.jpg)

Fig. 3 |. Cell cycle activity in cardiomyocytes. A high proliferative activity is characteristic of immature cardiomyocytes, whereas mature cells are largely quiescent and polyploid. Critical regulators of cell cycle activity are highlighted. CDK, cyclin-dependent kinase; n, haploid content of chromosomes.

hor Manusc   
  
hor Manusc   

<html><body><table><tr><td>Characteristic</td><td>Features of mature cardiomyocytes</td><td>Maturation gene markers</td><td>Assessment</td></tr><tr><td rowspan="4">Morphology</td><td>↑Length to width ratio (anisotropic)</td><td rowspan="4"></td><td rowspan="4"> Imaging; patch clamp</td></tr><tr><td>Rod-shaped</td></tr><tr><td>↑ Cell size</td></tr><tr><td>↑ Membrane capacitance</td></tr><tr><td rowspan="6">Electrophysiology</td><td>No spontaneous beating</td><td></td><td rowspan="6">Patch clamp; multielectrode array; in vivo arrhythmogenicity</td></tr><tr><td>↑ Upstroke velocity</td><td>SCN5A</td></tr><tr><td>Resting membrane potential (more negative)</td><td>KCNJ2</td></tr><tr><td>↑ Action potential duration</td><td>CACNA1C</td></tr><tr><td>Gap junctions and adhesive junctions polarized to intercalated discs</td><td>GJA1</td></tr><tr><td>↑ Conduction velocity</td><td></td></tr><tr><td rowspan="4">Calcium handling</td><td></td><td rowspan="4"> ATP2A2, CACNAIC, RYR2,</td><td rowspan="4"> Imaging using fluorescent calcium indicators</td></tr><tr><td>↑ Calcium stores in sarcoplasmic reticulum ↑ Calciumcycling and dynamics</td></tr><tr><td>↑Calciumcyeling withadrenergic</td></tr><tr><td>stimulation</td></tr><tr><td rowspan="8">Contractility</td><td>T-tubule development</td><td rowspan="8">BIN1, JPH2 MYH7(in humans),Myh6(in</td><td>WGA labelling,BIN1 and/or JPH2 immunostaining to assess structural features Isometric contractile force measurements (Frank-Starling relationship);traction force</td></tr><tr><td>Organized sarcomeres ↑ Contractile force</td><td rowspan="7">rodents),MYL2,3 mifrecton and/ortrckingf ytoprlsmicgraulesorsaceomeres loptix) ierrost</td></tr><tr><td>↑ Sarcomere length (from 1.8 μm</td></tr><tr><td>(contracted) to 2.2 (um(relaxed)) ↑ β-MHC to a-MHC ratio</td></tr><tr><td>Change from N2BA titin isoform to N2B titin</td></tr><tr><td>Switch from ssTnI tocTnI expression</td></tr><tr><td>PKA-mediated enhancement of contractility</td></tr><tr><td></td></tr><tr><td rowspan="2">Metabolism</td><td>↑ Fattyaci utization</td><td>CPT1B</td><td rowspan="2">Masspectrometry; nuclear magnetic resonance spectroscopy; oxygen consumption (metabolic flux assays)</td></tr><tr><td>↑ Mitochondria number Proliferation</td><td>PGC1A, TFAM</td></tr><tr><td>Cell cycle</td><td></td><td>-</td><td>Imaging DNA synthesis using BrdUor EdU labelling; Ki67,pH3 or aurora B kinase immunostaining; live cell imaging for mitosis; isotope labelling for DNA synthesis; fluorescence intensity of DNA-bindingdyes</td></tr></table></body></html>

<html><body><table><tr><td>Level</td><td>Key findings to date</td><td>Future questions</td></tr><tr><td>Genome</td><td>Genetic variations nfluence hPSC phenotypes</td><td>What is the contribution of genetic variation to cardiomyocyte maturation in hPSC applications?</td></tr><tr><td>Epigenome</td><td>Dynamic changes in histone modifications and DNA methylation across development and identification of regulationof maturation by panels of microRNAs</td><td>How does the epigenetic state contribute to the maturity and/or immaturity of hPSC-CMs?</td></tr><tr><td>Transcriptome</td><td>Embryonic-like state of hPSC-CMs and identification of dysregulated genes in immature hPSC-CMs</td><td>Do changes at the RNA level reflect differences in protein expression and/or cellfunction? What limits maturation in vitro?Are differentially expressed genes necessary and sufficient for maturation?</td></tr><tr><td>Proteome</td><td>Fetal-like state of hPSC-CM</td><td>How do the various maturation approaches influence expressed proteins and post-translational states？</td></tr><tr><td>Metabolome</td><td>Identification oflipid biomarkers and flux of carbon sources,and discovering how the carbon source contributes to ATP production and nucleotide biosynthesis</td><td>How do metabolites influence the functional state of hPSC-CMs (such as contractility and electrophysiology)?</td></tr><tr><td>Environment</td><td>Contributions of substrate, co-culture with other cell types and celldensity to maturation; role of integrin and microRNA signalling</td><td>How do interactions between cells and/or 3D cues mediate maturation? What are the key paracrin or other environmental factors?</td></tr><tr><td>Organ</td><td>hPSC-CMs induce remuscularization of infarcted myocardium and restoration of function after infarct but engrafted cells are arrhythmogenic</td><td>How can we balance eficacy and benefits with risks of the immature state of hPSC-CMs for cell therapy? What is the optimal maturity phenotype for cell-replacement strategies?</td></tr></table></body></html>